/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Output;
import kd.bos.algox.CoGroupDataSetX;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.macc.faf.algox.FAFSQLBuilder;
import kd.macc.faf.algox.XDbOutput;
import kd.macc.faf.datasync.exec.Exec;
import kd.macc.faf.datasync.exec.data.DataExecSummary;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.datasync.exec.func.CalcAndComplementCoGroupFunction;
import kd.macc.faf.datasync.exec.func.FillDimensionHashMapFunction;
import kd.macc.faf.datasync.exec.func.IncrementSummaryCoGroupFunction;
import kd.macc.faf.datasync.exec.func.IncrementSummaryGroupReduceFunction;
import kd.macc.faf.datasync.exec.input.sum.MergeInput;

public class AlgoxIncrementSummaryExec
implements Exec<JobSession, Boolean> {
    private static final int batchSize = 1000;
    private final DataExecSummary syncSummary;
    private final List<MergeInput> mergeInputs;
    private int pos = 0;

    public AlgoxIncrementSummaryExec(DataExecSummary summary) {
        this.syncSummary = summary;
        this.mergeInputs = summary.getIncrementMergeInputs();
    }

    @Override
    public boolean hasNext() {
        return this.mergeInputs != null && this.pos < this.mergeInputs.size();
    }

    @Override
    public Boolean exec(JobSession session) {
        if (this.hasNext()) {
            List collect = this.mergeInputs.stream().skip(this.pos).limit(1000L).collect(Collectors.toList());
            this.pos += 1000;
            if (collect.isEmpty()) {
                return null;
            }
            for (MergeInput mergeInput : collect) {
                this.execSummary(session, mergeInput);
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void execSummary(JobSession session, MergeInput mergeInput) {
        DataSetX dsxSummary;
        DataSyncModel syncModel = this.syncSummary.getModel();
        DataSetX dsx_0 = session.fromInput(mergeInput.getDetailInput());
        if (syncModel.haveHashDim()) {
            dsx_0 = dsx_0.map((MapFunction)new FillDimensionHashMapFunction(dsx_0.getRowMeta(), syncModel.getHashDimensionList()));
            dsxSummary = dsx_0.groupBy(new String[]{syncModel.getOrgNumber()}).reduceGroup((GroupReduceFunction)new IncrementSummaryGroupReduceFunction(dsx_0.getRowMeta(), this.syncSummary));
        } else {
            dsxSummary = session.fromInput(mergeInput.getSumInput());
        }
        DataSetX dsx_1 = this.syncSummary.needCalc() ? dsxSummary.filter(syncModel.getPeriodNumber() + " = " + this.syncSummary.getPeriodId()) : dsxSummary;
        List<String> fields = syncModel.getAllDimensionFields();
        CoGroupDataSetX dsxCo = dsx_0.coGroup(dsx_1, (CoGroupFunction)new IncrementSummaryCoGroupFunction(dsx_0.getRowMeta(), fields, syncModel.getOrdinaryMeasure()));
        for (String field : fields) {
            dsxCo.on(field, field);
        }
        this.outToDetailTable(dsxCo.filter("collectstatus = 0"));
        DataSetX dsxSum = dsxCo.filter("collectstatus = 1");
        if (this.syncSummary.needCalc()) {
            DataSetX dsxPreData = dsxSummary.filter(syncModel.getPeriodNumber() + "= " + this.syncSummary.getPrePeriodId());
            dsxSum = this.coCalc(dsxSum, dsxPreData);
        }
        DataSetX dsXfilterUpdate = dsxSum.filter("summaryid = 0").select(syncModel.getUpdateSelectRows());
        XDbOutput updateOutput = new XDbOutput("fias", syncModel.getUpdateSumTableSQL(), dsXfilterUpdate.getRowMeta());
        dsXfilterUpdate.output((Output)updateOutput);
        DataSetX dsxOutToSum = dsxSum.filter("summaryid = 1").removeFields(new String[]{"summaryid", "operationstatus", "collectstatus"});
        this.outToSumTable(dsxOutToSum);
    }

    private DataSetX coCalc(DataSetX dsxSum, DataSetX dsxPreData) {
        DataSyncModel syncModel = this.syncSummary.getModel();
        CoGroupDataSetX coGroupDataSetX = dsxSum.coGroup(dsxPreData, (CoGroupFunction)new CalcAndComplementCoGroupFunction(dsxSum.getRowMeta(), this.syncSummary.buildDataExecCalculate()));
        List<String> fields = syncModel.getAllDimensionFields();
        for (String field : fields) {
            if (Objects.equals(field, syncModel.getPeriodNumber())) continue;
            coGroupDataSetX.on(field, field);
        }
        return coGroupDataSetX;
    }

    private void outToDetailTable(DataSetX dsxOutToDetail) {
        DataSyncModel syncModel = this.syncSummary.getModel();
        FAFSQLBuilder updateDetail = syncModel.getUpdateDetailTableSQL();
        XDbOutput dbOutputDetail = new XDbOutput("fias", updateDetail.toUpdateSQL(), updateDetail.getRowMeta());
        if (syncModel.haveHashDim()) {
            dsxOutToDetail.select(new String[]{"summaryid", "dimhash", "id"}).output((Output)dbOutputDetail);
        } else {
            dsxOutToDetail.select(new String[]{"summaryid", "id"}).output((Output)dbOutputDetail);
        }
    }

    private void outToSumTable(DataSetX dsxOutToSum) {
        DataSyncModel syncModel = this.syncSummary.getModel();
        if (syncModel.isHaveTimeField()) {
            dsxOutToSum = dsxOutToSum.addFields(new Field[]{new Field("fcreatetime", (DataType)DataType.TimestampType)}, new Object[]{new Date()});
        }
        String insertSQL = syncModel.getInsertSumTableSQL();
        XDbOutput dbOutputSum = new XDbOutput("fias", insertSQL, dsxOutToSum.getRowMeta());
        dsxOutToSum.output((Output)dbOutputSum);
    }
}

