/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algox.CoGroupDataSetX;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.macc.faf.algox.FAFSQLBuilder;
import kd.macc.faf.algox.XDbOutput;
import kd.macc.faf.datasync.exec.Exec;
import kd.macc.faf.datasync.exec.data.DataExecSummary;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.datasync.exec.func.CalcAndComplementCoGroupFunction;
import kd.macc.faf.datasync.exec.func.FillDimensionHashMapFunction;
import kd.macc.faf.datasync.exec.func.SyncDataToSumGroupReduceFunction;
import kd.macc.faf.datasync.exec.input.sum.MergeInput;

public class AlgoxSummaryExec
implements Exec<JobSession, Boolean> {
    private static final int batchSize = 1000;
    private final DataExecSummary syncSummary;
    private final List<MergeInput> mergeInputs;
    private int pos = 0;

    public AlgoxSummaryExec(DataExecSummary summary) {
        this.syncSummary = summary;
        this.mergeInputs = summary.getMergeInputs();
    }

    @Override
    public boolean hasNext() {
        return this.mergeInputs != null && this.pos < this.mergeInputs.size();
    }

    @Override
    public Boolean exec(JobSession session) {
        if (this.hasNext()) {
            List collect = this.mergeInputs.stream().skip(this.pos).limit(1000L).collect(Collectors.toList());
            this.pos += 1000;
            if (collect.isEmpty()) {
                return null;
            }
            for (MergeInput mergeInput : collect) {
                this.execSummary(session, mergeInput);
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void execSummary(JobSession session, MergeInput mergeInput) {
        DataSyncModel syncModel = this.syncSummary.getModel();
        DataSetX dsxDetail = session.fromInput(mergeInput.getDetailInput());
        if (syncModel.haveHashDim()) {
            dsxDetail = dsxDetail.map((MapFunction)new FillDimensionHashMapFunction(dsxDetail.getRowMeta(), syncModel.getHashDimensionList()));
        }
        DataSetX dsxGroup = dsxDetail.groupBy(syncModel.getAllDimensionFieldArray()).reduceGroup((GroupReduceFunction)new SyncDataToSumGroupReduceFunction(dsxDetail.getRowMeta(), syncModel.getOrdinaryMeasure()));
        this.outToDetailTable(dsxGroup.filter("collectstatus = 0"));
        DataSetX dsxSum = dsxGroup.filter("collectstatus = 1");
        Input[] preDataInput = mergeInput.getSumInput();
        if (preDataInput != null) {
            DataSetX dsxPreData = session.fromInput(preDataInput);
            dsxPreData = dsxPreData.addFields(new Field[]{new Field("summaryid", (DataType)DataType.LongType)}, new Object[]{1L});
            dsxSum = this.coCalc(dsxSum, dsxPreData);
        }
        DataSetX dsxOutToSum = dsxSum.filter("summaryid = 1").removeFields(new String[]{"summaryid", "operationstatus", "collectstatus"});
        if (syncModel.isHaveTimeField()) {
            dsxOutToSum = dsxOutToSum.addFields(new Field[]{new Field("fcreatetime", (DataType)DataType.TimestampType)}, new Object[]{new Date()});
        }
        String insertSQL = syncModel.getInsertSumTableSQL();
        XDbOutput dbOutputSum = new XDbOutput("fias", insertSQL, dsxOutToSum.getRowMeta());
        dsxOutToSum.output((Output)dbOutputSum);
    }

    private DataSetX coCalc(DataSetX dsxSum, DataSetX dsxPreData) {
        DataSyncModel syncModel = this.syncSummary.getModel();
        CoGroupDataSetX coGroupDataSetX = dsxSum.coGroup(dsxPreData, (CoGroupFunction)new CalcAndComplementCoGroupFunction(dsxSum.getRowMeta(), this.syncSummary.buildDataExecCalculate()));
        List<String> fields = syncModel.getAllDimensionFields();
        for (String field : fields) {
            if (Objects.equals(field, syncModel.getPeriodNumber())) continue;
            coGroupDataSetX.on(field, field);
        }
        return coGroupDataSetX;
    }

    private void outToDetailTable(DataSetX dsxOutToDetail) {
        DataSyncModel syncModel = this.syncSummary.getModel();
        FAFSQLBuilder updateDetail = syncModel.getUpdateDetailTableSQL();
        XDbOutput dbOutputDetail = new XDbOutput("fias", updateDetail.toUpdateSQL(), updateDetail.getRowMeta());
        if (syncModel.haveHashDim()) {
            dsxOutToDetail.select(new String[]{"summaryid", "dimhash", "id"}).output((Output)dbOutputDetail);
        } else {
            dsxOutToDetail.select(new String[]{"summaryid", "id"}).output((Output)dbOutputDetail);
        }
    }
}

