/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.datasync.exec.data.CalcMeasure;
import kd.macc.faf.datasync.exec.data.DataExecCalculate;
import kd.macc.faf.datasync.exec.data.DataRecalculateParam;
import kd.macc.faf.datasync.exec.data.DataSyncModel;

public class DataExecRecalculate
implements Serializable {
    private static final long serialVersionUID = -5971658458878080379L;
    private DataSyncModel model;
    private DataRecalculateParam param;
    private Long prePeriodId;

    public DataExecRecalculate(DynamicObject model, DataRecalculateParam param) {
        this(new DataSyncModel(model), param);
    }

    public DataExecRecalculate(DataSyncModel model, DataRecalculateParam param) {
        this.model = model;
        this.param = param;
    }

    public Input getCurrPeriodSumInput() {
        QFilter orgQFilter = this.getOrgQFilter();
        QFilter periodQFilter = this.getPeriodQFilter(this.param.getPeriodId());
        return new OrmInput("faf.recalc.currperiod.input", this.model.getEntitynumber(), this.model.getSelectFields(), new QFilter[]{orgQFilter, periodQFilter});
    }

    public Input getPrevPeriodSumInput() {
        QFilter orgQFilter = this.getOrgQFilter();
        QFilter periodQFilter = this.getPeriodQFilter(this.getPrePeriodId());
        return new OrmInput("faf.recalc.prevperiod.input", this.model.getEntitynumber(), this.model.getSelectFields(), new QFilter[]{orgQFilter, periodQFilter});
    }

    private QFilter getOrgQFilter() {
        return new QFilter(this.model.getOrgNumber(), "in", this.param.getOrgIdSet());
    }

    private QFilter getPeriodQFilter(Long periodId) {
        if (periodId == null) {
            return QFilter.of((String)"1=0", (Object[])new Object[0]);
        }
        return new QFilter(this.model.getPeriodNumber(), "=", (Object)periodId);
    }

    private Long getPrePeriodId() {
        if (this.prePeriodId == null) {
            this.prePeriodId = this.getOnePrePeriod(this.param.getPeriodId());
        }
        return this.prePeriodId;
    }

    private Long getOnePrePeriod(Long periodId) {
        List<CalcMeasure> calcMeasures = this.model.getCalcMeasureList();
        if (calcMeasures == null || calcMeasures.isEmpty()) {
            return null;
        }
        Object periodtypeID = this.model.getPeriodtypeID();
        QFilter qFilter = new QFilter("periodtype", "=", periodtypeID).and("isadjustperiod", "=", (Object)"0").and("id", "<", (Object)periodId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"faf-query-getOnePrePeriod", (String)"bd_period", (String)"id", (QFilter[])qFilter.toArray(), (String)"number desc", (int)1);){
            Iterator iterator = dataSet.iterator();
            if (iterator.hasNext()) {
                Long l = ((Row)iterator.next()).getLong("id");
                return l;
            }
        }
        return null;
    }

    public DataExecCalculate buildDataExecCalculate() {
        DataExecCalculate execCalculate = new DataExecCalculate();
        execCalculate.setAccountNumber(this.model.getAccountFieldNumber());
        execCalculate.setPeriodNumber(this.model.getPeriodNumber());
        execCalculate.setPeriodId(this.param.getPeriodId());
        execCalculate.setOrdinaryMeasure(this.model.getOrdinaryMeasure());
        List<CalcMeasure> calcMeasures = this.getCalcMeasureList();
        Set<String> fields = calcMeasures.stream().map(CalcMeasure::getDimensionattrnb).flatMap(s -> Arrays.stream(s.split(","))).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        Map<String, Object> periodCalcMap = this.queryPeriodCalcMap(fields, this.param.getPeriodId());
        Map<String, Object> prePeriodCalcMap = this.queryPeriodCalcMap(fields, this.getPrePeriodId());
        for (CalcMeasure calcMeasure : calcMeasures) {
            calcMeasure.calc(periodCalcMap, prePeriodCalcMap);
            execCalculate.getCalcMeasureList().add(calcMeasure);
        }
        if (this.haveBlankDimensionattrnb(calcMeasures)) {
            execCalculate.setPltype0Set(this.model.queryAccountPltype0Set());
        }
        return execCalculate;
    }

    private List<CalcMeasure> getCalcMeasureList() {
        List<CalcMeasure> calcMeasures = this.model.getCalcMeasureList();
        return calcMeasures.stream().map(CalcMeasure::new).collect(Collectors.toList());
    }

    private Map<String, Object> queryPeriodCalcMap(Set<String> fields, Long periodId) {
        String selectFields = String.join((CharSequence)",", fields);
        QFilter qFilter = new QFilter("id", "=", (Object)periodId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"faf-query-queryPeriodCalcMap", (String)"bd_period", (String)selectFields, (QFilter[])qFilter.toArray(), null, (int)1);){
            Iterator iterator = dataSet.iterator();
            if (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                HashMap<String, Object> map = new HashMap<String, Object>(fields.size());
                for (String field : fields) {
                    map.put(field, row.get(field));
                }
                HashMap<String, Object> hashMap = map;
                return hashMap;
            }
        }
        return Collections.emptyMap();
    }

    private boolean haveBlankDimensionattrnb(List<CalcMeasure> calcMeasures) {
        for (CalcMeasure calcMeasure : calcMeasures) {
            if (!StringUtils.isBlank((CharSequence)calcMeasure.getDimensionattrnb())) continue;
            return true;
        }
        return false;
    }

    public DataSyncModel getModel() {
        return this.model;
    }

    public DataRecalculateParam getParam() {
        return this.param;
    }
}

