/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.EmptyInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.datasync.exec.data.CalcMeasure;
import kd.macc.faf.datasync.exec.data.DataExecCalculate;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.datasync.exec.data.DataSyncParams;
import kd.macc.faf.datasync.exec.input.sum.MergeInput;
import kd.macc.faf.enums.TimeTypeEnum;

public class DataExecSummary
implements Serializable {
    private static final long serialVersionUID = -5484876038590466914L;
    private final DataSyncModel model;
    private final DataSyncParams params;
    private Long prePeriodId;

    public DataExecSummary(DynamicObject model, DataSyncParams params) {
        this(new DataSyncModel(model), params);
    }

    public DataExecSummary(DataSyncModel model, DataSyncParams params) {
        this.model = model;
        this.params = params;
    }

    public DataSyncParams getParams() {
        return this.params;
    }

    public DataSyncModel getModel() {
        return this.model;
    }

    public boolean needCalc() {
        return this.params.getExecCalc() != false && TimeTypeEnum.PERIOD.getCode().equals(this.params.getTimeType()) && !this.getModel().getCalcMeasureList().isEmpty();
    }

    public List<MergeInput> getMergeInputs() {
        MergeInput mergeInput = new MergeInput();
        List<QFilter> execQFilters = this.getExecQFilters(false);
        if (execQFilters == null) {
            throw new KDBizException("data sync end ,summary params is null.");
        }
        Input[] inputs = new Input[execQFilters.size()];
        for (int i = 0; i < execQFilters.size(); ++i) {
            inputs[i] = new OrmInput("faf.summary.input", this.model.getEntitynumber_d(), this.model.getSelectFields() + ",summaryid", execQFilters.get(i).toArray());
        }
        mergeInput.setDetailInput(inputs);
        if (this.needCalc()) {
            List<QFilter> prePeriodQfilter = this.getExecQFilters(true);
            if (prePeriodQfilter != null && !prePeriodQfilter.isEmpty()) {
                Input[] inputsSum = new Input[prePeriodQfilter.size()];
                for (int i = 0; i < prePeriodQfilter.size(); ++i) {
                    inputsSum[i] = new OrmInput("faf.summary.input", this.model.getEntitynumber(), this.model.getSelectFields(), prePeriodQfilter.get(i).toArray());
                }
                mergeInput.setSumInput(inputsSum);
            } else {
                RowMeta rowMeta = ORM.create().createRowMeta(this.model.getEntitynumber(), this.model.getSelectFields());
                mergeInput.setSumInput(new Input[]{new EmptyInput(rowMeta)});
            }
        }
        return Collections.singletonList(mergeInput);
    }

    public List<MergeInput> getIncrementMergeInputs() {
        MergeInput mergeInput = new MergeInput();
        List<QFilter> qFilters = this.getOrgQFilter();
        for (QFilter qFilter : qFilters) {
            qFilter.and(this.getPeriodQFilter(false));
        }
        Input[] inputs = new Input[qFilters.size()];
        for (int i = 0; i < qFilters.size(); ++i) {
            inputs[i] = new OrmInput("faf.summary.input", this.model.getEntitynumber_d(), this.model.getSelectFields() + ",summaryid", qFilters.get(i).toArray());
        }
        mergeInput.setDetailInput(inputs);
        List<QFilter> qFilters2 = this.getOrgQFilter();
        for (QFilter qFilter : qFilters2) {
            qFilter.and(this.getPeriodQFilter(true));
        }
        Input[] inputs2 = new Input[qFilters2.size()];
        for (int i = 0; i < qFilters2.size(); ++i) {
            inputs2[i] = new OrmInput("faf.summary.input", this.model.getEntitynumber(), this.model.getSelectFields(), qFilters2.get(i).toArray());
        }
        mergeInput.setSumInput(inputs2);
        return Collections.singletonList(mergeInput);
    }

    public Long getPeriodId() {
        return this.params.getPeriodId();
    }

    public Long getPrePeriodId() {
        if (this.prePeriodId == null) {
            this.prePeriodId = this.getOnePrePeriod(this.params.getPeriodId());
        }
        return this.prePeriodId;
    }

    private List<QFilter> getExecQFilters(boolean isPrePeriodData) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(101);
        qFilters.add(new QFilter(this.model.getOrgNumber(), "in", this.params.getOrgIdSet()));
        if (Objects.equals(TimeTypeEnum.DATE.getCode(), this.params.getTimeType())) {
            QFilter dateFilter = this.getTimeRangeQFilter();
            for (QFilter qFilter : qFilters) {
                qFilter.and(dateFilter);
            }
        } else {
            Set<Long> periodIdSet = this.params.getPeriodIdSet();
            if (periodIdSet.size() > 1) {
                QFilter periodFilter = new QFilter(this.model.getPeriodNumber(), "in", periodIdSet);
                for (QFilter qFilter : qFilters) {
                    qFilter.and(periodFilter);
                }
            } else {
                Long periodId;
                Long l = periodId = isPrePeriodData ? this.getPrePeriodId() : this.getPeriodId();
                if (periodId == null) {
                    return null;
                }
                QFilter periodFilter = new QFilter(this.model.getPeriodNumber(), "=", (Object)periodId);
                for (QFilter qFilter : qFilters) {
                    qFilter.and(periodFilter);
                }
            }
        }
        return qFilters;
    }

    public List<QFilter> getOrgQFilter() {
        ArrayList<QFilter> list = new ArrayList<QFilter>(10);
        Set<Long> orgIdSet = this.params.getOrgIdSet();
        int count = orgIdSet.size() / 10 + 1;
        ArrayList<Long> orgIdList = new ArrayList<Long>(count);
        for (Long orgid : orgIdSet) {
            if (orgIdList.size() >= count) {
                list.add(new QFilter(this.model.getOrgNumber(), "in", orgIdList));
                orgIdList = new ArrayList(count);
            }
            orgIdList.add(orgid);
        }
        if (!orgIdList.isEmpty()) {
            list.add(new QFilter(this.model.getOrgNumber(), "in", orgIdList));
        }
        return list;
    }

    public QFilter getPeriodQFilter(boolean containPrePeriod) {
        if (Objects.equals(TimeTypeEnum.DATE.getCode(), this.params.getTimeType())) {
            return this.getTimeRangeQFilter();
        }
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(this.getPeriodId());
        if (containPrePeriod && this.getPrePeriodId() != null) {
            list.add(this.getPrePeriodId());
        }
        return new QFilter(this.model.getPeriodNumber(), "in", list);
    }

    private QFilter getTimeRangeQFilter() {
        QFilter qFilter = null;
        if (this.params.getStartDate() != null) {
            qFilter = new QFilter(this.model.getPeriodNumber(), ">=", (Object)this.params.getStartDate());
        }
        if (this.params.getEndDate() != null) {
            QFilter temp = new QFilter(this.model.getPeriodNumber(), "<=", (Object)this.params.getEndDate());
            qFilter = qFilter == null ? temp : qFilter.and(temp);
        }
        return qFilter;
    }

    private Long getOnePrePeriod(Long periodId) {
        List<CalcMeasure> calcMeasures = this.model.getCalcMeasureList();
        if (calcMeasures == null || calcMeasures.isEmpty()) {
            return null;
        }
        Object periodtypeID = this.model.getPeriodtypeID();
        QFilter qFilter = new QFilter("periodtype", "=", periodtypeID).and("isadjustperiod", "=", (Object)"0").and("id", "<", (Object)periodId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"faf-query-getOnePrePeriod", (String)"bd_period", (String)"id", (QFilter[])qFilter.toArray(), (String)"number desc", (int)1);){
            Iterator iterator = dataSet.iterator();
            if (iterator.hasNext()) {
                Long l = ((Row)iterator.next()).getLong("id");
                return l;
            }
        }
        return null;
    }

    public DataExecCalculate buildDataExecCalculate() {
        DataExecCalculate execCalculate = new DataExecCalculate();
        execCalculate.setAccountNumber(this.model.getAccountFieldNumber());
        execCalculate.setPeriodNumber(this.model.getPeriodNumber());
        execCalculate.setPeriodId(this.getPeriodId());
        execCalculate.setOrdinaryMeasure(this.model.getOrdinaryMeasure());
        List<CalcMeasure> calcMeasures = this.getCalcMeasureList();
        Set<String> fields = calcMeasures.stream().map(CalcMeasure::getDimensionattrnb).flatMap(s -> Arrays.stream(s.split(","))).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        Map<String, Object> periodCalcMap = this.queryPeriodCalcMap(fields, this.getPeriodId());
        Map<String, Object> prePeriodCalcMap = this.queryPeriodCalcMap(fields, this.getPrePeriodId());
        for (CalcMeasure calcMeasure : calcMeasures) {
            calcMeasure.calc(periodCalcMap, prePeriodCalcMap);
            execCalculate.getCalcMeasureList().add(calcMeasure);
        }
        if (this.haveBlankDimensionattrnb(calcMeasures)) {
            execCalculate.setPltype0Set(this.model.queryAccountPltype0Set());
        }
        return execCalculate;
    }

    private boolean haveBlankDimensionattrnb(List<CalcMeasure> calcMeasures) {
        for (CalcMeasure calcMeasure : calcMeasures) {
            if (!StringUtils.isBlank((CharSequence)calcMeasure.getDimensionattrnb())) continue;
            return true;
        }
        return false;
    }

    public List<CalcMeasure> getCalcMeasureList() {
        List<CalcMeasure> calcMeasures = this.model.getCalcMeasureList();
        return calcMeasures.stream().map(CalcMeasure::new).collect(Collectors.toList());
    }

    public Map<String, Object> queryPeriodCalcMap(Set<String> fields, Long periodId) {
        String selectFields = String.join((CharSequence)",", fields);
        QFilter qFilter = new QFilter("id", "=", (Object)periodId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"faf-query-queryPeriodCalcMap", (String)"bd_period", (String)selectFields, (QFilter[])qFilter.toArray(), null, (int)1);){
            Iterator iterator = dataSet.iterator();
            if (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                HashMap<String, Object> map = new HashMap<String, Object>(fields.size());
                for (String field : fields) {
                    map.put(field, row.get(field));
                }
                HashMap<String, Object> hashMap = map;
                return hashMap;
            }
        }
        return Collections.emptyMap();
    }
}

