/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.data;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.macc.faf.datasync.exec.data.DataSyncTransfer;
import kd.macc.faf.helper.FAFDimensionHelper;

public class DataSyncCondition
implements Serializable {
    private static final long serialVersionUID = 5034287775994679023L;
    public final MainEntityType dataEntityType;
    private final Map<String, String> setValConditionMap;
    private Map<String, DataSyncTransfer> dataSyncTransferMap;
    private Map<String, String> scriptMap;
    private Map<String, FilterCondition> filterConditionMap;

    public DataSyncCondition(MainEntityType dataEntityType) {
        this.dataEntityType = dataEntityType;
        this.setValConditionMap = new LinkedHashMap<String, String>();
    }

    public MainEntityType getDataEntityType() {
        return this.dataEntityType;
    }

    public void putConditionJson(String dimNumber, String dimConditionJson) {
        this.setValConditionMap.put(dimNumber, dimConditionJson);
    }

    public Set<String> getConditionFields() {
        return this.setValConditionMap.keySet();
    }

    public FilterCondition getFilterCondition(String fieldKey) {
        return this.filterConditionMap.get(fieldKey);
    }

    public DataSyncTransfer getDataSyncTransfer(String fieldName) {
        return this.dataSyncTransferMap.get(fieldName);
    }

    public String getFormulaStr(String fieldKey) {
        return this.scriptMap.get(fieldKey);
    }

    public boolean isConfig() {
        return !this.setValConditionMap.isEmpty();
    }

    public void prepare(RowMeta rowMeta) {
        if (this.filterConditionMap != null) {
            return;
        }
        this.filterConditionMap = new LinkedHashMap<String, FilterCondition>(this.setValConditionMap.size());
        this.dataSyncTransferMap = new LinkedHashMap<String, DataSyncTransfer>();
        this.scriptMap = new LinkedHashMap<String, String>(this.setValConditionMap.size());
        Set<Map.Entry<String, String>> entries = this.setValConditionMap.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String fieldKey = entry.getKey();
            String dimConditionJson = this.setValConditionMap.get(fieldKey);
            if (StringUtils.isEmpty((CharSequence)dimConditionJson)) continue;
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)dimConditionJson, FilterCondition.class);
            this.filterConditionMap.put(fieldKey, filterCondition);
            List filterRows = filterCondition.getFilterRow();
            for (SimpleFilterRow filterRow : filterRows) {
                String fieldName = filterRow.getFieldName();
                int charIndex = fieldName.indexOf(46);
                if (charIndex <= -1) continue;
                String sourceFieldName = fieldName.substring(0, charIndex);
                IDataEntityProperty property = (IDataEntityProperty)this.dataEntityType.getAllFields().get(sourceFieldName);
                if (!(property instanceof BasedataProp)) continue;
                String entityNumber = ((BasedataProp)property).getBaseEntityId();
                String refField = fieldName.substring(charIndex + 1);
                DataSyncTransfer transfer = new DataSyncTransfer(fieldName, FAFDimensionHelper.getEntityFieldDataType((String)entityNumber, (String)refField));
                transfer.setTransferType("6");
                transfer.setSourceFieldName(sourceFieldName);
                transfer.setSourceFieldNameIndex(rowMeta.getFieldIndex(sourceFieldName));
                transfer.setSourceRefField(refField);
                transfer.setSourceRefFieldEntityname(entityNumber);
                this.dataSyncTransferMap.put(filterRow.getFieldName(), transfer);
            }
            CRCondition crCondition = new CRCondition();
            crCondition.setFilterCondition(filterCondition);
            String fullFormula = crCondition.buildFullFormula(this.dataEntityType);
            this.scriptMap.put(fieldKey, fullFormula);
        }
    }
}

