/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.algox.FAFSQLBuilder;
import kd.macc.faf.datasync.BusinessDynamicObjectFactory;
import kd.macc.faf.datasync.exec.data.CalcMeasure;
import kd.macc.faf.datasync.exec.data.DataSyncModel;

public class DataSyncDelete
implements Serializable {
    private static final long serialVersionUID = -6037560715032367400L;
    private final DataSyncModel model;

    public DataSyncDelete(Object modelPkvalue) {
        this(BusinessDynamicObjectFactory.createDataSyncModel(modelPkvalue));
    }

    public DataSyncDelete(DataSyncModel model) {
        this.model = model;
    }

    public void batchUpdateSummaryMeasure(Set<Object> detailPkSet) {
        Object summary;
        List<String> allMeasures = this.model.getAllMeasures();
        String accountFieldNumber = this.model.getAccountFieldNumber();
        String summarySelectFields = "id," + String.join((CharSequence)",", allMeasures);
        String detailSelectFields = summarySelectFields + ",summaryid," + accountFieldNumber;
        QFilter[] detailIdFilter = new QFilter("id", "in", detailPkSet).toArray();
        Set summaryIdSet = QueryServiceHelper.query((String)this.model.getEntitynumber_d(), (String)"summaryid", (QFilter[])detailIdFilter).stream().map(p -> p.get("summaryid")).collect(Collectors.toSet());
        HashMap<Long, Map> summaryMeasureMap = new HashMap<Long, Map>(summaryIdSet.size());
        QFilter[] summaryIdFilter = new QFilter("id", "in", summaryIdSet).toArray();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DataSyncDelete.getSummaryData", (String)this.model.getEntitynumber(), (String)summarySelectFields, (QFilter[])summaryIdFilter, (String)"id");){
            while (dataSet.hasNext()) {
                summary = dataSet.next();
                Long summaryId = summary.getLong("id");
                Map measureMap = summaryMeasureMap.computeIfAbsent(summaryId, k -> new HashMap(allMeasures.size()));
                for (String string : allMeasures) {
                    measureMap.put(string, summary.getBigDecimal(string));
                }
            }
        }
        List<CalcMeasure> calcMeasures = this.model.getCalcMeasureList();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DataSyncDelete.getDetailData", (String)this.model.getEntitynumber_d(), (String)detailSelectFields, (QFilter[])detailIdFilter, (String)"id");
        summary = null;
        try {
            while (dataSet.hasNext()) {
                BigDecimal selfVal;
                Map measureMap;
                Row detail = dataSet.next();
                Long summaryId = detail.getLong("summaryid");
                if (summaryId == null || Objects.equals(summaryId, 0L) || (measureMap = (Map)summaryMeasureMap.get(summaryId)) == null) continue;
                for (String measure : this.model.getOrdinaryMeasure()) {
                    selfVal = (BigDecimal)measureMap.get(measure);
                    BigDecimal delVal = detail.getBigDecimal(measure);
                    measureMap.put(measure, this.safeSubtract(selfVal, delVal));
                }
                for (CalcMeasure calcMeasure : calcMeasures) {
                    selfVal = (BigDecimal)measureMap.get(calcMeasure.getNumber());
                    BigDecimal linkDelVal = detail.getBigDecimal(calcMeasure.getLinkNumber());
                    if (StringUtils.isBlank((CharSequence)calcMeasure.getDimensionattrnb())) {
                        Set<Long> longs = this.model.queryAccountPltype0Set();
                        if (!longs.contains(detail.getLong(accountFieldNumber))) continue;
                        measureMap.put(calcMeasure.getNumber(), this.safeSubtract(selfVal, linkDelVal));
                        continue;
                    }
                    measureMap.put(calcMeasure.getNumber(), this.safeSubtract(selfVal, linkDelVal));
                }
            }
        }
        catch (Throwable detail) {
            summary = detail;
            throw detail;
        }
        finally {
            if (dataSet != null) {
                if (summary != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable detail) {
                        ((Throwable)summary).addSuppressed(detail);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        FAFSQLBuilder builder = new FAFSQLBuilder("t_" + this.model.getEntitynumber());
        boolean hasBuild = false;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(summaryMeasureMap.size());
        for (Map.Entry entry : summaryMeasureMap.entrySet()) {
            Object[] objectArray = new Object[allMeasures.size() + 1];
            Long summaryId = (Long)entry.getKey();
            Map measureMap = (Map)entry.getValue();
            for (int i = 0; i < allMeasures.size(); ++i) {
                String measure = allMeasures.get(i);
                objectArray[i] = measureMap.get(measure);
                if (hasBuild) continue;
                builder.set("f" + measure);
            }
            if (!hasBuild) {
                builder.where("fid");
            }
            objectArray[allMeasures.size()] = summaryId;
            paramList.add(objectArray);
            hasBuild = true;
        }
        if (!paramList.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fias"), (String)builder.toUpdateSQL(), paramList);
        }
    }

    private BigDecimal safeSubtract(BigDecimal val, BigDecimal subtrahend) {
        if (val == null) {
            return null;
        }
        if (subtrahend == null) {
            return val;
        }
        return val.subtract(subtrahend);
    }
}

