/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.algox.FAFJoinLinkInfo;
import kd.macc.faf.datasource.dynamic.FlexSourceField;
import kd.macc.faf.datasync.DataSyncBusinessHelper;
import kd.macc.faf.datasync.exec.data.DataSync;
import kd.macc.faf.datasync.exec.data.DataSyncTransfer;
import kd.macc.faf.datasync.exec.data.EntityProppertyPath;
import kd.macc.faf.enums.FAFDimensionTypeEnum;
import kd.macc.faf.helper.FAFDimensionHelper;
import kd.macc.faf.util.EntityUtils;

public class DataSyncDimension
extends DataSync {
    private static final long serialVersionUID = -8086423195496204545L;
    private final DataType dataType;
    private String sourceNumber;
    private IDataEntityProperty sourceProperty;
    private String sourceRefField;
    private FlexSourceField flexField;
    private String selectType;
    private String defaultValue;
    private boolean autoMatch = false;

    public DataSyncDimension(String number, DataType dataType) {
        super(number);
        this.dataType = dataType;
        this.sourceNumber = number;
        this.selectType = "1";
    }

    public DataSyncDimension(DynamicObject dynamic) {
        super(dynamic);
        this.dataType = FAFDimensionHelper.getDimensionAlgoDataType((DynamicObject)dynamic);
        this.sourceNumber = this.number;
        this.selectType = "1";
    }

    public FAFDimensionTypeEnum getDimensiontype() {
        if (this.dynamic == null) {
            return FAFDimensionTypeEnum.UNDEFINED;
        }
        return FAFDimensionTypeEnum.getEnum((String)this.dynamic.getString("dimensiontype"));
    }

    public String getSourceEntityname() {
        FAFDimensionTypeEnum dimensionTypeEnum = this.getDimensiontype();
        switch (dimensionTypeEnum) {
            case DATABASE: {
                return this.dynamic.getString("dimensionsource_id");
            }
            case ASSISTANTDATA: {
                return "bos_assistantdata_detail";
            }
            case PERIOD: {
                return "pa_analysisperiod";
            }
        }
        return null;
    }

    public Long getAssistanttype() {
        return this.dynamic.getLong("assistantsource_id");
    }

    public String getDisplayName() {
        return this.dynamic.getString("name");
    }

    public QFilter getQFilter() {
        String dimensiontype = this.getDynamic().getString("dimensiontype");
        if (FAFDimensionTypeEnum.DATABASE.eqScene((Object)dimensiontype)) {
            String grouptype = this.getDynamic().getString("typefield");
            Object group_id = this.getDynamic().get("group_id");
            if (StringUtils.isNotEmpty((CharSequence)grouptype) && group_id != null) {
                QFilter qFilter = new QFilter(grouptype, "=", group_id);
                if ("bd_period".equals(this.getDynamic().getString("dimensionsource_id"))) {
                    qFilter = qFilter.and("isadjustperiod", "=", (Object)"0");
                }
                return qFilter;
            }
            if ("pa_analysisperiod".equals(this.getDynamic().getString("dimensionsource_id"))) {
                return new QFilter("isadjust", "=", (Object)"0");
            }
            return null;
        }
        if (FAFDimensionTypeEnum.ASSISTANTDATA.eqScene((Object)dimensiontype)) {
            DynamicObject assistant = this.getDynamic().getDynamicObject("assistantsource");
            return new QFilter("group", "=", assistant.getPkValue());
        }
        return null;
    }

    public boolean isUsable(IDataEntityProperty property) {
        LocaleString displayName = property.getDisplayName();
        if (displayName == null) {
            return false;
        }
        return !this.unUsable(displayName.toString()) && !this.unUsable(property.getAlias());
    }

    private boolean unUsable(String propertyName) {
        return StringUtils.isEmpty((CharSequence)propertyName) || propertyName.startsWith("##");
    }

    public boolean match(IDataEntityProperty property) {
        if (!this.isUsable(property)) {
            return false;
        }
        if (this.dataType == DataType.BigDecimalType) {
            return property instanceof DecimalProp;
        }
        if (this.autoMatch && !Objects.equals(this.getDisplayName(), property.getDisplayName().toString())) {
            return false;
        }
        if (this.dataType == DataType.AnyType) {
            return property instanceof BasedataProp || property instanceof TextProp || property instanceof ComboProp || property instanceof DateTimeProp;
        }
        FAFDimensionTypeEnum dimensiontype = this.getDimensiontype();
        switch (dimensiontype) {
            case ASSISTANTDATA: {
                if (property instanceof AssistantProp) {
                    return Objects.equals(((AssistantProp)property).getAsstTypeId(), String.valueOf(this.getAssistanttype()));
                }
            }
            case DATABASE: 
            case PERIOD: {
                if (property instanceof ItemClassProp) {
                    ItemClassTypeProp itemClassTypeProp = EntityUtils.getItemClassTypeProp((ItemClassProp)property);
                    if (itemClassTypeProp == null) break;
                    List baseEntityIds = itemClassTypeProp.getBaseEntityIds();
                    return baseEntityIds.contains(this.getSourceEntityname());
                }
                if (!(property instanceof BasedataProp)) break;
                return Objects.equals(((BasedataProp)property).getBaseEntityId(), this.getSourceEntityname());
            }
            case OTHER: 
            case DENUMS: {
                return property instanceof TextProp || property instanceof ComboProp;
            }
            case DATE: {
                return property instanceof DateTimeProp;
            }
        }
        return false;
    }

    public boolean match(FlexSourceField flexField) {
        if (this.dataType == DataType.BigDecimalType) {
            return false;
        }
        if (this.autoMatch && !Objects.equals(this.getDisplayName(), flexField.getName())) {
            return false;
        }
        if (this.dataType == DataType.AnyType) {
            return Objects.equals(flexField.getValuetype(), "1") || Objects.equals(flexField.getValuetype(), "2") || Objects.equals(flexField.getValuetype(), "3");
        }
        FAFDimensionTypeEnum dimensiontype = this.getDimensiontype();
        switch (dimensiontype) {
            case DATABASE: {
                String entityname = this.getSourceEntityname();
                return Objects.equals(flexField.getValuetype(), "1") && Objects.equals(flexField.getValuesource(), entityname);
            }
            case ASSISTANTDATA: {
                return Objects.equals(flexField.getValuetype(), "2") && Objects.equals(flexField.getAssistanttype(), this.getAssistanttype());
            }
            case OTHER: 
            case DENUMS: {
                return Objects.equals(flexField.getValuetype(), "3");
            }
            case DATE: {
                return false;
            }
        }
        return false;
    }

    public boolean matchAIasstacttype(Row row) {
        String datatype;
        if (this.dataType == DataType.BigDecimalType) {
            return false;
        }
        if (this.dataType == DataType.AnyType) {
            return true;
        }
        switch (datatype = row.getString("datatype")) {
            case "1": {
                if (!FAFDimensionTypeEnum.DATABASE.eq((Object)this.getDimensiontype()) || !Objects.equals(this.getSourceEntityname(), row.get("valuesource"))) break;
                return true;
            }
            case "2": {
                if (!FAFDimensionTypeEnum.ASSISTANTDATA.eq((Object)this.getDimensiontype()) || !Objects.equals(this.getAssistanttype(), row.getLong("assistanttype"))) break;
                return true;
            }
            default: {
                if (!FAFDimensionTypeEnum.OTHER.eq((Object)this.getDimensiontype())) break;
                return true;
            }
        }
        return false;
    }

    public boolean matchComassist(String baseEntityId, Long assistantTypeId) {
        if (this.dataType == DataType.BigDecimalType) {
            return false;
        }
        if (this.dataType == DataType.AnyType) {
            return true;
        }
        if ("bos_assistantdata_detail".equals(baseEntityId) && assistantTypeId != null) {
            return FAFDimensionTypeEnum.ASSISTANTDATA == this.getDimensiontype() && Objects.equals(this.getAssistanttype(), assistantTypeId);
        }
        String entityname = this.getSourceEntityname();
        return FAFDimensionTypeEnum.DATABASE == this.getDimensiontype() && Objects.equals(baseEntityId, entityname);
    }

    public void setDimensionfield(String dimensionfield) {
        if (StringUtils.isEmpty((CharSequence)dimensionfield)) {
            this.sourceNumber = dimensionfield;
            return;
        }
        if (dimensionfield.contains("-")) {
            this.setSelectType("6");
            String[] split = dimensionfield.split("-");
            if (split.length > 0) {
                this.sourceNumber = split[0];
            }
            if (split.length > 1) {
                this.sourceRefField = split[1];
            }
        } else {
            this.sourceNumber = dimensionfield;
        }
    }

    public String getSourceNumber() {
        return this.sourceNumber;
    }

    public void setSourceNumber(String sourceNumber) {
        this.sourceNumber = sourceNumber;
    }

    public IDataEntityProperty getSourceProperty() {
        return this.sourceProperty;
    }

    public void setSourceProperty(IDataEntityProperty sourceProperty) {
        this.sourceProperty = sourceProperty;
    }

    public FlexSourceField getFlexField() {
        return this.flexField;
    }

    public void setSourceFlexField(FlexSourceField flexField) {
        this.flexField = flexField;
    }

    public FAFJoinLinkInfo getFlexFieldJoinInfo() {
        FAFJoinLinkInfo link = new FAFJoinLinkInfo();
        link.setEntityName(this.flexField.getFormNumber());
        link.setLeftField(this.getSourceNumber());
        link.setRightField("hg");
        link.addLinkField(this.flexField.getFlexfield(), this.flexField.getDataType());
        return link;
    }

    public String getSourceRefField() {
        return this.sourceRefField;
    }

    public String getSourceRefFieldEntityname() {
        if (this.getSourceProperty() instanceof ItemClassProp) {
            throw new KDBizException("not support source property is ItemClassProp.");
        }
        if (this.getSourceProperty() instanceof BasedataProp) {
            return ((BasedataProp)this.getSourceProperty()).getBaseEntityId();
        }
        FlexSourceField flexField = this.getFlexField();
        if (flexField != null) {
            return flexField.getValuesource();
        }
        if (this.getSourceNumber() != null && this.getSourceNumber().startsWith("dim_")) {
            return DataSyncBusinessHelper.getAIasstacttypeBaseEntiyIdMap(this.getSourceNumber().substring("dim_".length()));
        }
        return "";
    }

    public String getSelectType() {
        return this.selectType;
    }

    public void setSelectType(String selectType) {
        this.selectType = selectType;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Object getDefaultValue() {
        if (StringUtils.isEmpty((CharSequence)this.defaultValue)) {
            return this.defaultValue;
        }
        String sourceEntityname = this.getSourceEntityname();
        if (StringUtils.isNotEmpty((CharSequence)sourceEntityname)) {
            return this.dataType == DataType.LongType ? Long.valueOf(this.defaultValue) : this.defaultValue;
        }
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValueText() {
        QFilter qFilter;
        DynamicObject dynamicObject;
        if (StringUtils.isEmpty((CharSequence)this.defaultValue)) {
            return null;
        }
        String sourceEntityname = this.getSourceEntityname();
        if (StringUtils.isNotEmpty((CharSequence)sourceEntityname) && (dynamicObject = QueryServiceHelper.queryOne((String)sourceEntityname, (String)"name", (QFilter[])(qFilter = new QFilter("id", "=", this.getDefaultValue())).toArray())) != null) {
            return dynamicObject.getString("name");
        }
        FAFDimensionTypeEnum dimensiontype = this.getDimensiontype();
        if (dimensiontype == FAFDimensionTypeEnum.DENUMS) {
            return this.getDynamic().getDynamicObjectCollection("entryentityenums").stream().filter(entry -> this.defaultValue.equals(entry.getString("value"))).findFirst().map(dy -> dy.getString("title")).orElse(this.defaultValue);
        }
        return this.defaultValue;
    }

    public DataSyncTransfer createSyncTransfer() {
        ItemClassTypeProp itemClassTypeProp;
        IDataEntityProperty property;
        DataSyncTransfer syncTransfer = new DataSyncTransfer(this.number, this.dataType);
        syncTransfer.setTransferType(this.getSelectType());
        syncTransfer.setValue(this.getDefaultValue());
        syncTransfer.setSourceFieldName(this.getSourceNumber());
        if (this.getFlexField() != null) {
            syncTransfer.setFlexfield(this.getFlexField().getFlexfield());
        }
        if ((property = this.getSourceProperty()) instanceof ItemClassProp && (itemClassTypeProp = EntityUtils.getItemClassTypeProp((ItemClassProp)property)) != null) {
            EntityProppertyPath entityProppertyPath = new EntityProppertyPath((IDataEntityProperty)itemClassTypeProp);
            syncTransfer.setSourceFieldTypePropName(entityProppertyPath.getName());
        }
        syncTransfer.setTargetFieldEntityname(this.getSourceEntityname());
        return syncTransfer;
    }

    public QFilter getQFilter(Set<Long> periodIdSet) {
        QFilter periodFilter = null;
        String dimensionEntityname = this.getSourceEntityname();
        String sourceField = this.getSourceNumber();
        if (this.getSourceProperty() instanceof DateTimeProp) {
            Map periodMap;
            ArrayList<QFilter> periodQFilters = new ArrayList<QFilter>(periodIdSet.size());
            if ("bd_period".equals(dimensionEntityname)) {
                periodMap = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)"id, begindate, enddate", (QFilter[])new QFilter[]{new QFilter("id", "in", periodIdSet)});
                for (DynamicObject dyn : periodMap.values()) {
                    periodQFilters.add(new QFilter(sourceField, ">=", dyn.get("begindate")).and(sourceField, "<=", dyn.get("enddate")));
                }
            } else if ("pa_analysisperiod".equals(dimensionEntityname)) {
                periodMap = BusinessDataServiceHelper.loadFromCache((String)"pa_analysisperiod", (String)"id, startdate, enddate", (QFilter[])new QFilter[]{new QFilter("id", "in", periodIdSet)});
                for (DynamicObject dyn : periodMap.values()) {
                    periodQFilters.add(new QFilter(sourceField, ">=", dyn.get("startdate")).and(sourceField, "<=", dyn.get("enddate")));
                }
            }
            for (QFilter filter : periodQFilters) {
                if (periodFilter == null) {
                    periodFilter = filter;
                    continue;
                }
                periodFilter.or(filter);
            }
        }
        return periodFilter;
    }

    public boolean isAutoMatch() {
        return this.autoMatch;
    }

    public void setAutoMatch(boolean autoMatch) {
        this.autoMatch = autoMatch;
    }

    public boolean isImport() {
        if (this.dynamic != null) {
            String systemsource = this.dynamic.getString("systemsource");
            return Arrays.asList("1", "2", "3").contains(systemsource);
        }
        return false;
    }

    public String toString() {
        return "{sourceNumber='" + this.sourceNumber + '\'' + ", selectType='" + this.selectType + '\'' + ", defaultValue='" + this.defaultValue + '\'' + ", number='" + this.number + '\'' + '}';
    }
}

