/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.macc.faf.datasync.exec.data.DataSync;
import kd.macc.faf.datasync.exec.data.DataSyncDimension;
import kd.macc.faf.datasync.exec.impl.BcmSyncDimension;

public class DataSyncMapping
extends DataSync {
    private static final long serialVersionUID = -3427836709756664553L;
    private final String target;
    private Map<Map<String, Object>, Map<String, Object>> mappingSourceToTarget;
    private List<DataSyncDimension> sourceDimensions;
    private List<String> sourceFields;
    private Map<String, Object> s_sourceToTarget;

    public DataSyncMapping(DynamicObject dynamic, String target) {
        super(dynamic);
        this.target = target;
    }

    private String buildSourceValueKey(List<String> sourceFields, LinkedHashMap<String, Object> sourceValuesMap) {
        return sourceFields.stream().map(s -> String.valueOf(sourceValuesMap.get(s))).collect(Collectors.joining("_"));
    }

    private void generatorMappingData(boolean loadTargetToSource) {
        DynamicObjectCollection entryentity = this.dynamic.getDynamicObjectCollection("entryentity");
        if (loadTargetToSource) {
            this.mappingSourceToTarget = new HashMap<Map<String, Object>, Map<String, Object>>(entryentity.size());
        }
        this.s_sourceToTarget = new HashMap<String, Object>(entryentity.size());
        for (DynamicObject entry : entryentity) {
            String sourcedimtext = entry.getString("sourcedimtext");
            String targetdimtext = entry.getString("targetdimtext");
            LinkedHashMap sourceValuesMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)sourcedimtext, LinkedHashMap.class);
            LinkedHashMap targetValuesMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)targetdimtext, LinkedHashMap.class);
            if (loadTargetToSource) {
                this.mappingSourceToTarget.put(sourceValuesMap, targetValuesMap);
            }
            this.s_sourceToTarget.put(this.buildSourceValueKey(this.getSourceFields(), sourceValuesMap), targetValuesMap.get(this.target));
        }
    }

    private boolean contains(Set<Long> targetVals, Object targetVal) {
        if (targetVals == null) {
            return false;
        }
        if (targetVal == null) {
            return targetVals.contains(null);
        }
        if (targetVal instanceof Long) {
            return targetVals.contains((Long)targetVal);
        }
        try {
            return targetVals.contains(Long.valueOf(String.valueOf(targetVal)));
        }
        catch (Exception ex) {
            return false;
        }
    }

    public List<Map<String, Object>> mappingParams(String targetFieldNumber, Set<Long> targetValues) {
        if (this.mappingSourceToTarget == null) {
            this.generatorMappingData(true);
        }
        List<DataSyncDimension> dimensions = this.getSourceDimensions();
        HashMap<DataSyncDimension, Map<Object, String>> dimIdToNumMap = new HashMap<DataSyncDimension, Map<Object, String>>(dimensions.size());
        for (DataSyncDimension dimension : dimensions) {
            dimIdToNumMap.put(dimension, null);
        }
        HashSet<Map<String, Object>> sourceMapSet = new HashSet<Map<String, Object>>();
        HashMap sourceIDs = new HashMap();
        Set<Map.Entry<Map<String, Object>, Map<String, Object>>> sTtEntries = this.mappingSourceToTarget.entrySet();
        for (Map.Entry<Map<String, Object>, Map<String, Object>> entry : sTtEntries) {
            Map<String, Object> sourceMap = entry.getKey();
            Map<String, Object> targetMap = entry.getValue();
            Object targetVal = targetMap.get(targetFieldNumber);
            if (!this.contains(targetValues, targetVal)) continue;
            sourceMapSet.add(sourceMap);
            for (DataSyncDimension dimension : dimensions) {
                if (!(dimension instanceof BcmSyncDimension)) continue;
                Object val = sourceMap.get(dimension.getNumber());
                Set ids = (Set)sourceIDs.get(dimension);
                if (ids == null) {
                    HashSet<Object> set = new HashSet<Object>();
                    set.add(val);
                    sourceIDs.put(dimension, set);
                    continue;
                }
                ids.add(val);
            }
        }
        Set entriedSet = sourceIDs.entrySet();
        for (Map.Entry entry : entriedSet) {
            DataSyncDimension dimension = (DataSyncDimension)entry.getKey();
            if (!(dimension instanceof BcmSyncDimension)) continue;
            Map<Object, String> tTsMapping = ((BcmSyncDimension)dimension).loadIdToNumberMap((Collection)entry.getValue());
            dimIdToNumMap.put((DataSyncDimension)entry.getKey(), tTsMapping);
        }
        return this.getMaps(sourceMapSet, dimIdToNumMap);
    }

    private List<Map<String, Object>> getMaps(Set<Map<String, Object>> sourceMapSet, Map<DataSyncDimension, Map<Object, String>> dimIdToNumMap) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(sourceMapSet.size());
        for (Map<String, Object> sourceMap : sourceMapSet) {
            HashMap<String, Object> map = new HashMap<String, Object>(dimIdToNumMap.size());
            for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
                String sourceDimensionNumber = entry.getKey();
                Object sourceDimensionVal = entry.getValue();
                for (Map.Entry<DataSyncDimension, Map<Object, String>> mapEntry : dimIdToNumMap.entrySet()) {
                    DataSyncDimension dimension = mapEntry.getKey();
                    Map<Object, String> idToNumber = mapEntry.getValue();
                    if (!Objects.equals(sourceDimensionNumber, dimension.getNumber())) continue;
                    if (idToNumber == null) {
                        map.put(dimension.getSourceNumber(), sourceDimensionVal);
                        continue;
                    }
                    map.put(dimension.getSourceNumber(), idToNumber.get(sourceDimensionVal));
                }
            }
            maps.add(map);
        }
        return maps;
    }

    public List<String> getSourceFields() {
        if (this.sourceFields == null) {
            DynamicObjectCollection sourcedim = this.dynamic.getDynamicObjectCollection("sourcedim");
            this.sourceFields = new ArrayList<String>(sourcedim.size());
            for (DynamicObject dynamicObject : sourcedim) {
                DynamicObject fbasedataid = dynamicObject.getDynamicObject("fbasedataid");
                this.sourceFields.add(fbasedataid.getString("number"));
            }
        }
        return this.sourceFields;
    }

    public Map<String, Object> getS_sourceToTarget() {
        if (this.s_sourceToTarget == null) {
            this.generatorMappingData(false);
        }
        return this.s_sourceToTarget;
    }

    public List<DataSyncDimension> getSourceDimensions() {
        if (this.sourceDimensions == null) {
            return Collections.emptyList();
        }
        return this.sourceDimensions;
    }

    public void setSourceDimensions(List<DataSyncDimension> sourceDimensions) {
        this.sourceDimensions = sourceDimensions;
    }
}

