/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.algox.FAFSQLBuilder;
import kd.macc.faf.datasync.exec.data.CalcMeasure;
import kd.macc.faf.datasync.exec.data.DataSync;
import kd.macc.faf.enums.DataSourceTypeEnum;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.ImportSystemSourceTypeEnum;
import kd.macc.faf.enums.MeasureTypeEnum;
import kd.macc.faf.enums.OperationStatusEnum;
import kd.macc.faf.helper.BizVoucherHelper;
import kd.macc.faf.util.AnalysisModelHashUtil;
import kd.macc.faf.util.AnalysisModelUtil;

public class DataSyncModel
extends DataSync {
    private static final long serialVersionUID = -3427836709756664553L;
    private final List<String> allDimensionFields;
    private String entityname;
    private String entityname_d;
    private DynamicObject orgField = null;
    private DynamicObject periodField = null;
    private DynamicObject accountField = null;
    private List<String> fields;
    private List<String> ordinaryMeasure;
    private List<DynamicObject> calculateMeasure;
    private Object periodtypeID;
    private Boolean haveHashDim;
    private Object accountTableId;
    private List<DynamicObject> importDimensionLinkList;
    private ImportSystemSourceTypeEnum importSystemSource = null;
    private List<CalcMeasure> calcMeasureList;
    private Set<Long> accountPltype0Set;

    public DataSyncModel(DynamicObject dynamic) {
        super(dynamic);
        DynamicObjectCollection entry = dynamic.getDynamicObjectCollection("dimension_entry");
        this.allDimensionFields = new ArrayList<String>(entry.size());
        for (DynamicObject dyn : entry) {
            DynamicObject dimension = dyn.getDynamicObject("dimension");
            String number = dimension.getString("number");
            this.allDimensionFields.add(number);
            String necessity = dyn.getString("necessity_dim");
            if (DimensionNecessityEnum.ORG.getCode().equals(necessity)) {
                this.orgField = dimension;
            }
            if (DimensionNecessityEnum.PERIOD.getCode().equals(necessity)) {
                this.periodField = dimension;
                this.periodtypeID = dimension.get("group_id");
            }
            if (!DimensionNecessityEnum.ACCOUNT.getCode().equals(necessity)) continue;
            this.accountField = dimension;
            this.accountTableId = dimension.get("group_id");
        }
    }

    public boolean isNecessity(Object pkValue) {
        if (pkValue == null) {
            return false;
        }
        if (this.orgField == null || this.periodField == null || this.accountField == null) {
            return false;
        }
        return Objects.equals(pkValue, this.orgField.getPkValue()) || Objects.equals(pkValue, this.periodField.getPkValue()) || Objects.equals(pkValue, this.accountField.getPkValue());
    }

    public String getEntitynumber() {
        if (this.entityname == null) {
            this.generatorEntityInfo();
        }
        return this.entityname;
    }

    public String getEntitynumber_d() {
        if (this.entityname_d == null) {
            this.generatorEntityInfo();
        }
        return this.entityname_d;
    }

    private void generatorEntityInfo() {
        String tablenumber = this.dynamic.getString("tablenumber");
        if (StringUtils.isEmpty((CharSequence)tablenumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u88ab\u5220\u9664\u3002", (String)"DataSyncModel_0", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        this.entityname = AnalysisModelUtil.buildEntityNumber((String)tablenumber);
        this.entityname_d = AnalysisModelUtil.buildDetailEntityNumber((String)tablenumber);
    }

    public String buildInsertDetailTableSQL(RowMeta rowMeta, String sourceformid) {
        FAFSQLBuilder builder = new FAFSQLBuilder("t_" + this.getEntitynumber_d());
        for (String fieldName : rowMeta.getFieldNames()) {
            builder.insert("f" + fieldName);
        }
        return builder.insert("fcollectstatus", "0").insert("foperationstatus", "0").insert("fdatastatus", "0").insert("fdel", "0").insert("fsituationtype", "0").insert("foffstatus", "0").insertV("fsourceformid", sourceformid).toInsertSQL();
    }

    public String getOrgNumber() {
        if (this.orgField == null) {
            return "";
        }
        return this.orgField.getString("number");
    }

    public DynamicObject getOrgField() {
        if (this.orgField == null) {
            throw new KDBizException("org is null.");
        }
        return this.orgField;
    }

    public String getPeriodNumber() {
        if (this.periodField == null) {
            return "";
        }
        return this.periodField.getString("number");
    }

    public DynamicObject getPeriodField() {
        if (this.periodField == null) {
            throw new KDBizException("period is null.");
        }
        return this.periodField;
    }

    public String getAccountFieldNumber() {
        if (this.accountField == null) {
            return "";
        }
        return this.accountField.getString("number");
    }

    public DynamicObject getAccountField() {
        return this.accountField;
    }

    public Object getAccountTableId() {
        return this.accountTableId;
    }

    public String getSelectFields() {
        if (this.fields == null) {
            this.generator();
        }
        return String.join((CharSequence)",", this.fields);
    }

    public List<CalcMeasure> getCalcMeasureList() {
        if (this.calcMeasureList == null) {
            List<DynamicObject> calculateMeasureList = this.getCalculateMeasureList();
            this.calcMeasureList = new ArrayList<CalcMeasure>(calculateMeasureList.size());
            for (DynamicObject measure : calculateMeasureList) {
                CalcMeasure calcMeasure = new CalcMeasure();
                calcMeasure.setNumber(measure.getString("number"));
                calcMeasure.setLinkNumber(measure.getDynamicObject("measure").getString("number"));
                calcMeasure.setDimensionattrnb(measure.getString("dimensionattrnb"));
                this.calcMeasureList.add(calcMeasure);
            }
        }
        return this.calcMeasureList;
    }

    public List<DynamicObject> getCalculateMeasureList() {
        if (this.calculateMeasure == null) {
            this.generator();
        }
        return this.calculateMeasure;
    }

    public List<String> getCalculateMeasureNumbers() {
        if (this.calculateMeasure == null) {
            this.generator();
        }
        return this.calculateMeasure.stream().map(dynamicObject -> dynamicObject.getString("number")).collect(Collectors.toList());
    }

    public Object getPeriodtypeID() {
        if (this.periodtypeID == null) {
            this.generator();
        }
        return this.periodtypeID;
    }

    public DynamicObjectCollection getDimensionEntry() {
        return this.dynamic.getDynamicObjectCollection("dimension_entry");
    }

    public DynamicObjectCollection getMeasureEntry() {
        return this.dynamic.getDynamicObjectCollection("measure_entry");
    }

    public List<String> getAllDimensionFields() {
        return this.allDimensionFields;
    }

    public String[] getAllDimensionFieldArray() {
        return this.allDimensionFields.toArray(new String[0]);
    }

    public List<String> getOrdinaryMeasure() {
        if (this.ordinaryMeasure == null) {
            this.generator();
        }
        return this.ordinaryMeasure;
    }

    public List<String> getAllMeasures() {
        ArrayList<String> list = new ArrayList<String>(this.getOrdinaryMeasure().size() + this.getCalculateMeasureNumbers().size());
        list.addAll(this.getOrdinaryMeasure());
        list.addAll(this.getCalculateMeasureNumbers());
        return list;
    }

    private void generator() {
        DynamicObjectCollection dEntry = this.dynamic.getDynamicObjectCollection("dimension_entry");
        DynamicObjectCollection mEntry = this.dynamic.getDynamicObjectCollection("measure_entry");
        this.fields = new ArrayList<String>(dEntry.size() + mEntry.size());
        this.fields.add("id");
        if (this.haveHashDim()) {
            this.fields.add("dimhash");
        }
        this.fields.add("operationstatus");
        this.fields.add("collectstatus");
        for (DynamicObject entry : dEntry) {
            DynamicObject dimension = entry.getDynamicObject("dimension");
            String number = dimension.getString("number");
            this.fields.add(number);
        }
        this.calculateMeasure = new ArrayList<DynamicObject>(mEntry.size());
        this.ordinaryMeasure = new ArrayList<String>(8);
        ArrayList<String> tempCalculatefields = new ArrayList<String>(2);
        for (DynamicObject entry : mEntry) {
            DynamicObject measure = entry.getDynamicObject("measure");
            String number = measure.getString("number");
            String measuretype = measure.getString("measuretype");
            if (String.valueOf(MeasureTypeEnum.CALCULATION.getCode()).equals(measuretype)) {
                if (!this.ableCalculate(measure)) continue;
                tempCalculatefields.add(number);
                this.calculateMeasure.add(measure);
                continue;
            }
            this.ordinaryMeasure.add(number);
            this.fields.add(number);
        }
        this.fields.addAll(tempCalculatefields);
    }

    private boolean ableCalculate(DynamicObject measure) {
        DynamicObject dimension = BusinessDataServiceHelper.loadSingleFromCache((Object)measure.getDynamicObject("dimension").getPkValue(), (String)"pa_dimension");
        String number = dimension.getString("number");
        return this.getPeriodNumber().equals(number) && "bd_period".equals(dimension.getDynamicObject("dimensionsource").getPkValue());
    }

    public Map<String, Object> getImportInfo() {
        Iterator<DynamicObject> iterator;
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<DynamicObject> importdimensionLinkList = this.getImportDimensionLinkList();
        List<DynamicObject> importMeasurenLinkList = this.getImportMeasureLinkList();
        if (this.getSourceType() == null || this.getSourceType() == ImportSystemSourceTypeEnum.NEW) {
            return Collections.emptyMap();
        }
        map.put("importType", this.getSourceType());
        map.put("importdimensionLinkList", importdimensionLinkList);
        map.put("importMeasurenLinkList", importMeasurenLinkList);
        if (this.getSourceType() == ImportSystemSourceTypeEnum.ASSTACT) {
            return map;
        }
        if (!importdimensionLinkList.isEmpty() && (iterator = importdimensionLinkList.iterator()).hasNext()) {
            DynamicObject next = iterator.next();
            map.put("importSystemId", next.get("immodel"));
            return map;
        }
        if (!importMeasurenLinkList.isEmpty() && (iterator = importMeasurenLinkList.iterator()).hasNext()) {
            DynamicObject next = iterator.next();
            map.put("importSystemId", next.get("immodel"));
            return map;
        }
        return Collections.emptyMap();
    }

    public List<DynamicObject> getImportDimensionLinkList() {
        DynamicObjectCollection collection;
        QFilter qfilter;
        DynamicObjectCollection dEntry = this.getDimensionEntry();
        Map<Long, DynamicObject> dimensionMap = dEntry.stream().map(entry -> entry.getDynamicObject("dimension")).filter(dynamicObject -> {
            ImportSystemSourceTypeEnum systemsource = ImportSystemSourceTypeEnum.getEnumByCode((String)dynamicObject.getString("systemsource"));
            return systemsource != ImportSystemSourceTypeEnum.NEW;
        }).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject));
        if (dimensionMap.isEmpty()) {
            return Collections.emptyList();
        }
        for (DynamicObject dimension : dimensionMap.values()) {
            ImportSystemSourceTypeEnum systemsource = ImportSystemSourceTypeEnum.getEnumByCode((String)dimension.getString("systemsource"));
            if (systemsource == ImportSystemSourceTypeEnum.NEW) continue;
            if (this.importSystemSource == null) {
                this.importSystemSource = systemsource;
                continue;
            }
            if (this.importSystemSource == systemsource) continue;
            throw new KDBizException("sync schema import dimensino/measure is multi type.");
        }
        if (this.importSystemSource == ImportSystemSourceTypeEnum.ASSTACT) {
            qfilter = new QFilter("id", "in", dimensionMap.keySet());
            collection = QueryServiceHelper.query((String)this.importSystemSource.getDimmappingTable(), (String)this.importSystemSource.getSelectFields(), (QFilter[])qfilter.toArray());
            return new ArrayList<DynamicObject>((Collection<DynamicObject>)collection);
        }
        if (this.importSystemSource == ImportSystemSourceTypeEnum.BCM || this.importSystemSource == ImportSystemSourceTypeEnum.EPM) {
            qfilter = new QFilter("dimension", "in", dimensionMap.keySet());
            collection = QueryServiceHelper.query((String)this.importSystemSource.getDimmappingTable(), (String)this.importSystemSource.getSelectFields(), (QFilter[])qfilter.toArray());
            return new ArrayList<DynamicObject>((Collection<DynamicObject>)collection);
        }
        return Collections.emptyList();
    }

    public List<DynamicObject> getImportMeasureLinkList() {
        DynamicObjectCollection mEntry = this.getMeasureEntry();
        Map<Long, DynamicObject> measureMap = mEntry.stream().map(entry -> entry.getDynamicObject("measure")).filter(dynamicObject -> {
            ImportSystemSourceTypeEnum systemsource = ImportSystemSourceTypeEnum.getEnumByCode((String)dynamicObject.getString("systemsource"));
            return systemsource != ImportSystemSourceTypeEnum.NEW;
        }).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject));
        if (measureMap.isEmpty()) {
            return Collections.emptyList();
        }
        for (DynamicObject measure : measureMap.values()) {
            ImportSystemSourceTypeEnum systemsource = ImportSystemSourceTypeEnum.getEnumByCode((String)measure.getString("systemsource"));
            if (systemsource == ImportSystemSourceTypeEnum.NEW) continue;
            if (this.importSystemSource == null) {
                this.importSystemSource = systemsource;
                continue;
            }
            if (this.importSystemSource == systemsource) continue;
            throw new KDBizException("sync schema import dimensino/measure is multi type.");
        }
        ImportSystemSourceTypeEnum importSourceType = this.importSystemSource;
        if (importSourceType == ImportSystemSourceTypeEnum.BCM || importSourceType == ImportSystemSourceTypeEnum.EPM) {
            QFilter qfilter = new QFilter("measure", "in", measureMap.keySet());
            DynamicObjectCollection collection = QueryServiceHelper.query((String)importSourceType.getMeasureMappingTable(), (String)importSourceType.getMeasureMappingSelectFields(), (QFilter[])qfilter.toArray());
            return new ArrayList<DynamicObject>((Collection<DynamicObject>)collection);
        }
        return Collections.emptyList();
    }

    public Map<String, String> getMatchImportDimension(DataSourceTypeEnum sourceType, Long dimensionId) {
        if (this.importDimensionLinkList == null) {
            this.importDimensionLinkList = this.getImportDimensionLinkList();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (DynamicObject dynamicObject : this.importDimensionLinkList) {
            long dimension = dynamicObject.getLong("dimension");
            if (dimensionId != null && !Objects.equals(dimensionId, dimension)) continue;
            if (sourceType == DataSourceTypeEnum.BIZVOUCHER) {
                map.put(BizVoucherHelper.addPrefix((String)dynamicObject.getString("asstacttype.flexfiled")), BizVoucherHelper.addNamePrefix((String)dynamicObject.getString("asstacttype.name")));
                continue;
            }
            if (sourceType != DataSourceTypeEnum.BCM && sourceType != DataSourceTypeEnum.EPM) continue;
            map.put(dynamicObject.getString("imdimnumber"), dynamicObject.getString("imdimname"));
        }
        map.remove(null);
        return map;
    }

    public List<String> getHashDimensionList() {
        DynamicObjectCollection dEntry = this.dynamic.getDynamicObjectCollection("dimension_entry");
        return dEntry.stream().map(dynamicObject -> dynamicObject.getDynamicObject("dimension")).filter(dynamicObject -> !Objects.equals(dynamicObject.getPkValue(), this.getPeriodField().getPkValue())).sorted(Comparator.comparingLong(dy -> dy.getLong("id"))).map(dy -> dy.getString("number")).collect(Collectors.toList());
    }

    public FAFSQLBuilder getUpdateDetailTableSQL() {
        FAFSQLBuilder builder = new FAFSQLBuilder("t_" + this.getEntitynumber_d()).set("fsummaryid", (DataType)DataType.LongType);
        if (this.haveHashDim()) {
            builder.set("fdimhash", (DataType)DataType.StringType);
        }
        builder.set("foperationstatus", OperationStatusEnum.USED.getCodeString()).where().eq("fid", (DataType)DataType.LongType);
        return builder;
    }

    public String getInsertSumTableSQL() {
        FAFSQLBuilder builder = new FAFSQLBuilder("t_" + this.getEntitynumber());
        for (String field : this.fields) {
            if (field.equals("collectstatus") || field.equals("operationstatus")) continue;
            builder.insert("f" + field);
        }
        builder.insert("fcollectstatus", "1").insert("foperationstatus", "0").insert("fdatastatus", "0").insert("fdel", "0").insert("fsituationtype", "0").insert("foffstatus", "0");
        if (this.isHaveTimeField()) {
            builder.insert("fcreatetime");
        }
        return builder.toInsertSQL();
    }

    public String[] getUpdateSelectRows() {
        ArrayList<String> list = new ArrayList<String>(this.getOrdinaryMeasure());
        list.addAll(this.getCalculateMeasureNumbers());
        list.add("id");
        list.add(this.getOrgNumber());
        list.add(this.getPeriodNumber());
        return list.toArray(new String[0]);
    }

    public String getUpdateSumTableSQL() {
        FAFSQLBuilder builder = new FAFSQLBuilder("t_" + this.getEntitynumber());
        List<String> measureList = this.getOrdinaryMeasure();
        for (String field : measureList) {
            builder.set("f" + field);
        }
        for (DynamicObject dynamicObject : this.calculateMeasure) {
            builder.set("f" + dynamicObject.get("number"));
        }
        return builder.where("fid").eq("f" + this.getOrgNumber(), (DataType)DataType.LongType).eq("f" + this.getPeriodNumber(), (DataType)DataType.LongType).toUpdateSQL();
    }

    public String[] getUpdateCalcMeasureSelectRows() {
        ArrayList<String> list = new ArrayList<String>(this.getCalculateMeasureNumbers());
        list.add("id");
        list.add(this.getOrgNumber());
        list.add(this.getPeriodNumber());
        return list.toArray(new String[0]);
    }

    public String getUpdateCalcMeasureSumTableSQL() {
        FAFSQLBuilder builder = new FAFSQLBuilder("t_" + this.getEntitynumber());
        for (DynamicObject dynamicObject : this.calculateMeasure) {
            builder.set("f" + dynamicObject.get("number"));
        }
        return builder.where("fid").eq("f" + this.getOrgNumber(), (DataType)DataType.LongType).eq("f" + this.getPeriodNumber(), (DataType)DataType.LongType).toUpdateSQL();
    }

    public boolean isHaveTimeField() {
        return EntityMetadataCache.getDataEntityType((String)this.getEntitynumber()).getProperty("createtime") != null;
    }

    public boolean haveHashDim() {
        if (this.haveHashDim == null) {
            this.haveHashDim = AnalysisModelHashUtil.isModelContainsDimHash((String)this.getEntitynumber()) && AnalysisModelHashUtil.isModelContainsDimHash((String)this.getEntitynumber_d());
        }
        return this.haveHashDim;
    }

    public Long getSystemId() {
        return this.getDynamic().getLong("analysis_system_id");
    }

    public ImportSystemSourceTypeEnum getSourceType() {
        return this.importSystemSource;
    }

    public Set<Long> queryAccountPltype0Set() {
        if (this.accountPltype0Set == null) {
            this.accountPltype0Set = new HashSet<Long>();
            QFilter qFilter = new QFilter("accounttable", "=", this.getAccountTableId()).and(new QFilter("pltype", "=", (Object)"0"));
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"faf-query-queryPeriodCalcMap", (String)"bd_accountview", (String)"id", (QFilter[])qFilter.toArray(), null, (int)100000);){
                for (Row row : dataSet) {
                    this.accountPltype0Set.add(row.getLong("id"));
                }
            }
        }
        return this.accountPltype0Set;
    }
}

