/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.datasource.dynamic.BcmDataSource;
import kd.macc.faf.datasource.dynamic.DataSource;
import kd.macc.faf.datasource.dynamic.EntityDataSource;
import kd.macc.faf.datasource.dynamic.EpmDataSource;
import kd.macc.faf.datasource.dynamic.FlexSourceField;
import kd.macc.faf.datasync.exec.data.DataSync;
import kd.macc.faf.datasync.exec.data.DataSyncDimension;
import kd.macc.faf.datasync.exec.data.DataSyncMapping;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.datasync.exec.data.DataSyncParams;
import kd.macc.faf.datasync.exec.data.DataSyncTransfer;
import kd.macc.faf.enums.DataSourceTypeEnum;
import kd.macc.faf.enums.ImportSystemSourceTypeEnum;
import kd.macc.faf.enums.SelectTypeEnum;
import kd.macc.faf.enums.TimeTypeEnum;
import kd.macc.faf.util.CalculateCondition;

public abstract class DataSyncSchema<T extends DataSource>
extends DataSync {
    private static final long serialVersionUID = 6424260831306194599L;
    protected final DataSyncModel syncModel;
    private final DynamicObjectCollection dEntry;
    private final DynamicObjectCollection mEntry;
    private final T dataSource;
    private final Set<String> sourceMeasures = new LinkedHashSet<String>();
    protected Map<String, DataSyncDimension> syncDimensionMap;
    protected Map<String, DataSyncMapping> syncMappingMap;
    protected RowMeta sourceRowMeta;
    private List<DataSyncTransfer> transfers;
    private String matchModel = "";
    private List<DataSyncDimension> dataSyncDimensions;

    public DataSyncSchema(DynamicObject schemaDynamic, DataSyncModel syncModel, DataSource dataSource) {
        super(schemaDynamic);
        this.syncModel = syncModel;
        try {
            this.dataSource = (DataSource)FAFUtils.cast((Object)dataSource);
        }
        catch (Exception exception) {
            throw new KDBizException("data sync schema datasource type is mot match.");
        }
        this.dEntry = schemaDynamic.getDynamicObjectCollection("dimensionmapentry");
        this.mEntry = schemaDynamic.getDynamicObjectCollection("measuremapentry");
    }

    public T getDataSource() {
        return this.dataSource;
    }

    public DataSyncModel getSyncModel() {
        return this.syncModel;
    }

    public DynamicObjectCollection getDimensionMapEntry() {
        return this.dEntry;
    }

    public DynamicObjectCollection getMeasureMapEntry() {
        return this.mEntry;
    }

    protected Map<String, DataSyncMapping> getSyncMappingMap() {
        if (this.syncMappingMap == null) {
            this.generatorSyncMapping();
        }
        return this.syncMappingMap;
    }

    protected void generatorSyncMapping() {
        this.syncMappingMap = new HashMap<String, DataSyncMapping>();
        for (DynamicObject entry : this.getDimensionMapEntry()) {
            if (!StringUtils.equals((CharSequence)"2", (CharSequence)entry.getString("dimensionselecttype"))) continue;
            String number = entry.getString("dimension.number");
            DynamicObject dynamicMapping = entry.getDynamicObject("mappingrelationship");
            if (dynamicMapping == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u201c%s\u201d\u6620\u5c04\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataSyncSchema_0", (String)"macc-faf-business", (Object[])new Object[0]), number));
            }
            DataSyncMapping syncMapping = new DataSyncMapping(dynamicMapping, number);
            DynamicObjectCollection sourcedim = dynamicMapping.getDynamicObjectCollection("sourcedim");
            ArrayList<DataSyncDimension> sourceDimensions = new ArrayList<DataSyncDimension>(sourcedim.size());
            for (DynamicObject dynamicObject : sourcedim) {
                DynamicObject fbasedataid = dynamicObject.getDynamicObject("fbasedataid");
                DataSyncDimension syncDimension = this.getSyncDimensionMap().get(fbasedataid.getString("number"));
                if (syncDimension != null) {
                    sourceDimensions.add(syncDimension);
                    continue;
                }
                sourceDimensions.add(new DataSyncDimension(fbasedataid));
            }
            syncMapping.setSourceDimensions(sourceDimensions);
            this.syncMappingMap.put(number, syncMapping);
        }
    }

    protected Map<String, DataSyncDimension> getXSyncDimensionMap() {
        return Collections.emptyMap();
    }

    public List<DataSyncDimension> getSettingSyncDimensionList() {
        if (this.dataSyncDimensions == null) {
            this.dataSyncDimensions = new ArrayList<DataSyncDimension>();
            for (DynamicObject entry : this.getDimensionMapEntry()) {
                DynamicObject dimension = entry.getDynamicObject("dimension");
                DataSyncDimension syncDimension = new DataSyncDimension(dimension);
                syncDimension.setSelectType(entry.getString("dimensionselecttype"));
                syncDimension.setDefaultValue(entry.getString("dimdefaultvalue"));
                String dimensionfield = entry.getString("dimensionfield");
                syncDimension.setDimensionfield(dimensionfield);
                T dsource = this.getDataSource();
                if (dsource instanceof EntityDataSource) {
                    EntityDataSource dataSource = (EntityDataSource)dsource;
                    IDataEntityProperty sourceProp = dataSource.getFieldType(syncDimension.getSourceNumber());
                    syncDimension.setSourceProperty(sourceProp);
                    Map<String, FlexSourceField> flexField = dataSource.getFlexField(syncDimension.getSourceNumber());
                    Set<Map.Entry<String, FlexSourceField>> entries = flexField.entrySet();
                    Iterator<Map.Entry<String, FlexSourceField>> iterator = entries.iterator();
                    if (iterator.hasNext()) {
                        Map.Entry<String, FlexSourceField> next = iterator.next();
                        syncDimension.setSourceNumber(next.getKey());
                        syncDimension.setSourceFlexField(next.getValue());
                    }
                }
                this.dataSyncDimensions.add(syncDimension);
            }
        }
        return this.dataSyncDimensions;
    }

    public Map<String, DataSyncDimension> getSyncDimensionMap() {
        if (this.syncDimensionMap == null) {
            this.syncDimensionMap = new LinkedHashMap<String, DataSyncDimension>();
            this.syncDimensionMap.putAll(this.getXSyncDimensionMap());
            List<DataSyncDimension> dimensionList = this.getSettingSyncDimensionList();
            for (DataSyncDimension syncDimension : dimensionList) {
                if (this.syncDimensionMap.containsKey(syncDimension.getNumber())) continue;
                this.syncDimensionMap.put(syncDimension.getNumber(), syncDimension);
            }
        }
        return this.syncDimensionMap;
    }

    public Map<String, DataSyncDimension> getFlexDataSyncDimensionMap() {
        return this.getSyncDimensionMap().values().stream().filter(dataSyncDimension -> dataSyncDimension.getFlexField() != null).collect(Collectors.toMap(new Function<DataSyncDimension, String>(){

            @Override
            public String apply(DataSyncDimension dataSyncDimension) {
                return dataSyncDimension.getSourceNumber() + dataSyncDimension.getFlexField().getFlexfield();
            }
        }, dataSyncDimension -> dataSyncDimension, (o, o2) -> o));
    }

    public Map<String, OrmInput> getFlexFieldOrmInput(String flexNumber) {
        HashMap<String, OrmInput> ormInputMap = new HashMap<String, OrmInput>(4);
        HashMap<String, HashSet<String>> flexFormFieldMap = new HashMap<String, HashSet<String>>(2);
        Map<String, DataSyncDimension> dimensionMap = this.getSyncDimensionMap();
        for (DataSyncDimension dataSyncDimension : dimensionMap.values()) {
            FlexSourceField flexField = dataSyncDimension.getFlexField();
            if (flexField == null || flexField.getProp() == null || !flexNumber.equals(flexField.getProp().getName())) continue;
            String formNumber = flexField.getFormNumber();
            if (flexFormFieldMap.get(formNumber) == null) {
                flexFormFieldMap.put(formNumber, new HashSet<String>(Collections.singleton(flexField.getFlexfield())));
                continue;
            }
            ((Set)flexFormFieldMap.get(formNumber)).add(flexField.getFlexfield());
        }
        for (Map.Entry entry : flexFormFieldMap.entrySet()) {
            String formNumber = (String)entry.getKey();
            OrmInput ormInput = new OrmInput("kd.fi.pa.datasync.GlBalanceSchemaExec." + formNumber, formNumber, this.getSelectFiled(formNumber), this.buildtFilter(formNumber, (Set)entry.getValue()));
            ormInputMap.put(formNumber, ormInput);
        }
        return ormInputMap;
    }

    public String getSourceOrgNumber() {
        Map<String, DataSyncDimension> dimensionMap = this.getSyncDimensionMap();
        DataSyncDimension syncDimension = dimensionMap.get(this.syncModel.getOrgNumber());
        return syncDimension.getSourceNumber();
    }

    public List<Map<String, Object>> mappingParams(String fieldNumber, Set<Long> idSet) {
        Map<String, DataSyncMapping> shipDynamicMap = this.getSyncMappingMap();
        DataSyncMapping syncMapping = shipDynamicMap.get(fieldNumber);
        if (syncMapping != null) {
            return syncMapping.mappingParams(fieldNumber, idSet);
        }
        return null;
    }

    public List<QFilter> getParamsQFilters(DataSyncParams params) {
        if (TimeTypeEnum.DATE.getCode().equals(params.getTimeType())) {
            return this.getParamsQFilters(params.getOrgIdSet(), params.getStartDate(), params.getEndDate());
        }
        return this.getParamsQFilters(params.getOrgIdSet(), params.getPeriodIdSet());
    }

    public List<QFilter> getParamsQFilters(Object[] orgIds, Object[] periodIds) {
        Set<Long> orgIdSet = Arrays.stream(orgIds).map(o -> (Long)o).collect(Collectors.toSet());
        Set<Long> periodIdSet = Arrays.stream(periodIds).map(o -> (Long)o).collect(Collectors.toSet());
        return this.getParamsQFilters(orgIdSet, periodIdSet);
    }

    public List<QFilter> getParamsQFilters(Object[] orgIds, Date startDate, Date endDate) {
        Set<Long> orgIdSet = Arrays.stream(orgIds).map(o -> (Long)o).collect(Collectors.toSet());
        return this.getParamsQFilters(orgIdSet, startDate, endDate);
    }

    public List<QFilter> getParamsQFilters(Set<Long> orgIdSet, Date startDate, Date endDate) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(this.mappingParamsQFilter(this.syncModel.getOrgNumber(), orgIdSet));
        DataSyncDimension periodDimension = this.getSyncDimensionMap().get(this.syncModel.getPeriodNumber());
        if (startDate != null) {
            list.add(new QFilter(periodDimension.getSourceNumber(), ">=", (Object)startDate));
        }
        if (endDate != null) {
            list.add(new QFilter(periodDimension.getSourceNumber(), "<", (Object)endDate));
        }
        return list;
    }

    public List<QFilter> getParamsQFilters(Set<Long> orgIdSet, Set<Long> periodIdSet) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(this.mappingParamsQFilter(this.syncModel.getOrgNumber(), orgIdSet));
        T source = this.getDataSource();
        String entityNumber = ((DataSource)source).getEntityNumber();
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            String periodNumber = this.syncModel.getPeriodNumber();
            DataSyncDimension periodSync = this.getSyncDimensionMap().get(periodNumber);
            QFilter qFilter = periodSync.getQFilter(periodIdSet);
            if (qFilter != null) {
                list.add(qFilter);
                return list;
            }
        }
        list.add(this.mappingParamsQFilter(this.syncModel.getPeriodNumber(), periodIdSet));
        return list;
    }

    private QFilter mappingParamsQFilter(String fieldNumber, Set<Long> idSet) {
        DataSyncMapping syncMapping = this.getSyncMappingMap().get(fieldNumber);
        if (syncMapping == null) {
            DataSyncDimension dimension = this.getSyncDimensionMap().get(fieldNumber);
            return new QFilter(dimension.getSourceNumber(), "in", idSet);
        }
        List<Map<String, Object>> mapList = syncMapping.mappingParams(fieldNumber, idSet);
        List<DataSyncDimension> dimensions = syncMapping.getSourceDimensions();
        if (mapList == null || mapList.isEmpty() || dimensions.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\u201c%s\u201d\u7684\u7ef4\u5ea6\uff0c\u53d6\u6570\u53c2\u6570\u6ca1\u6709\u6620\u5c04\u5230\u4efb\u4f55\u6e90\u7ef4\u5ea6\u503c\u3002", (String)"DataSyncSchema_1", (String)"macc-faf-business", (Object[])new Object[0]), fieldNumber));
        }
        if (dimensions.size() == 1) {
            DataSyncDimension dimension = dimensions.get(0);
            HashSet<Object> set = new HashSet<Object>(mapList.size());
            for (Map<String, Object> objectMap : mapList) {
                set.add(objectMap.get(dimension.getSourceNumber()));
            }
            return new QFilter(dimension.getSourceNumber(), "in", set);
        }
        QFilter orQfilter = null;
        for (Map<String, Object> objectMap : mapList) {
            QFilter andQfilter = null;
            for (DataSyncDimension dimension : dimensions) {
                QFilter temp = new QFilter(dimension.getSourceNumber(), "=", objectMap.get(dimension.getSourceNumber()));
                if (andQfilter == null) {
                    andQfilter = temp;
                    continue;
                }
                andQfilter.and(temp);
            }
            if (orQfilter == null) {
                orQfilter = andQfilter;
                continue;
            }
            orQfilter.or(andQfilter);
        }
        return orQfilter;
    }

    public List<DataSyncTransfer> getDataTransfers() {
        if (this.transfers == null) {
            Collection<DataSyncDimension> values = this.getSyncDimensionMap().values();
            this.transfers = new ArrayList<DataSyncTransfer>(values.size() + this.getMeasureMapEntry().size());
            for (DataSyncDimension syncDimension : values) {
                DataSyncTransfer syncTransfer = syncDimension.createSyncTransfer();
                if (Objects.equals(syncDimension.getSelectType(), "2")) {
                    String dimensionNumber = syncDimension.getNumber();
                    DataSyncMapping syncMapping = this.getSyncMappingMap().get(dimensionNumber);
                    syncTransfer.setSourceFields(syncMapping.getSourceFields());
                    syncTransfer.setS_sourceToTarget(syncMapping.getS_sourceToTarget());
                } else if (Objects.equals(syncDimension.getSelectType(), "6")) {
                    String refField = syncDimension.getSourceRefField();
                    String entityname = this.getSourceRefFieldEntityname(syncDimension);
                    syncTransfer.setSourceRefField(refField);
                    syncTransfer.setSourceRefFieldEntityname(entityname);
                }
                this.transfers.add(syncTransfer);
            }
            for (DynamicObject entry : this.getMeasureMapEntry()) {
                DynamicObject measure = entry.getDynamicObject("measure");
                String measureNumber = measure.getString("number");
                String selecttype = entry.getString("selecttype");
                DataSyncTransfer syncTransfer = new DataSyncTransfer(measureNumber, (DataType)DataType.BigDecimalType);
                if ("3".equals(selecttype)) {
                    syncTransfer.setTransferType("1");
                    T dataSource = this.getDataSource();
                    if (dataSource instanceof BcmDataSource) {
                        syncTransfer.setSourceFieldName(measureNumber);
                    } else {
                        String measurefield = entry.getString("measurefield");
                        syncTransfer.setSourceFieldName(measurefield);
                        this.sourceMeasures.add(measurefield);
                    }
                } else if ("4".equals(selecttype)) {
                    syncTransfer.setTransferType("1");
                    String dimmeasurefield = entry.getString("dimmeasurefield");
                    syncTransfer.setSourceFieldName(dimmeasurefield);
                } else if ("2".equals(selecttype)) {
                    syncTransfer.setTransferType("3");
                    syncTransfer.setValue(entry.getBigDecimal("measuredefaultvalue"));
                } else if ("1".equals(selecttype)) {
                    syncTransfer.setTransferType("4");
                    String conditionString = entry.getString("condition_tag");
                    CalculateCondition condition = new CalculateCondition(((DataSource)this.getDataSource()).getEntityNumber(), conditionString);
                    Set propertys = condition.parseProperty();
                    syncTransfer.setSourceFields(new ArrayList<String>(propertys));
                    syncTransfer.setDataSourceEntityNumber(((DataSource)this.getDataSource()).getEntityNumber());
                    syncTransfer.setCondition(conditionString);
                }
                this.transfers.add(syncTransfer);
            }
        }
        return this.transfers;
    }

    protected String getSourceRefFieldEntityname(DataSyncDimension syncDimension) {
        return syncDimension.getSourceRefFieldEntityname();
    }

    public Set<String> getSourceMeasures() {
        return this.sourceMeasures;
    }

    public String buildOutSQL(RowMeta rowMeta) {
        return this.syncModel.buildInsertDetailTableSQL(rowMeta, ((DataSource)this.getDataSource()).getEntityNumber());
    }

    public String getMatchModel() {
        return this.matchModel;
    }

    public void setMatchModel(String matchModel) {
        this.matchModel = matchModel;
    }

    public abstract Map<String, String> matchFields(Object var1);

    public abstract List<ComboItem> matchMeasureFields();

    public abstract Object matchMeasureField(Object var1);

    public abstract List<List<Input>> getInputs(DataSyncParams var1);

    public String getSelectFiled(String formNumber) {
        if (formNumber.startsWith("bd_flexauxprop")) {
            return "hg, auxproptype, auxpropval";
        }
        if (formNumber.startsWith("gl_assist")) {
            return "hg, asstype, assval";
        }
        throw new KDBizException("not support formNumber " + formNumber);
    }

    public QFilter[] buildtFilter(String formNumber, Set<String> assTypeSet) {
        if (formNumber.startsWith("bd_flexauxprop")) {
            return new QFilter[]{new QFilter("auxproptype", "in", assTypeSet)};
        }
        if (formNumber.startsWith("gl_assist")) {
            return new QFilter[]{new QFilter("asstype", "in", assTypeSet)};
        }
        throw new KDBizException("not support formNumber " + formNumber);
    }

    public Set<Long> matchMapping(Long dimensionPkvalue) {
        DynamicObject[] load;
        HashSet<Long> set = new HashSet<Long>();
        QFilter qFilter = new QFilter("anasystem", "=", (Object)this.syncModel.getSystemId());
        Set dimensionIdSet = this.syncModel.getDimensionEntry().stream().map(dynamic -> dynamic.getLong("dimension_id")).collect(Collectors.toSet());
        for (DynamicObject ship : load = BusinessDataServiceHelper.load((String)"pa_mappingrelationship", (String)"id,sourcedim,targetdim", (QFilter[])qFilter.toArray())) {
            Set targetdimSet;
            Set sourcedimSet = ship.getDynamicObjectCollection("sourcedim").stream().map(dynamic -> dynamic.getLong("fbasedataid_id")).collect(Collectors.toSet());
            if (!dimensionIdSet.containsAll(sourcedimSet) || !(targetdimSet = ship.getDynamicObjectCollection("targetdim").stream().map(dynamic -> dynamic.getLong("fbasedataid_id")).collect(Collectors.toSet())).contains(dimensionPkvalue)) continue;
            set.add(ship.getLong("id"));
        }
        return set;
    }

    public QFilter matchDataSources() {
        QFilter filter = new QFilter("analysismodel", "=", this.getSyncModel().getPkValue()).and("id", "!=", this.getPkValue());
        HashSet<Long> exsitIdList = new HashSet<Long>();
        HashSet<String> exsitEntityNumber = new HashSet<String>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"match_datasource", (String)"pa_syncdataschema", (String)"datasource.id,datasource.entity_number", (QFilter[])filter.toArray(), null);){
            for (Row row : dataSet) {
                exsitIdList.add(row.getLong("datasource.id"));
                String entityNumber = row.getString("datasource.entity_number");
                if (!StringUtils.isNotEmpty((CharSequence)entityNumber)) continue;
                exsitEntityNumber.add(entityNumber);
            }
        }
        QFilter qFilter = new QFilter("id", "not in", exsitIdList).and("entity_number", "not in", exsitEntityNumber);
        DynamicObject periodField = this.getSyncModel().getPeriodField();
        if (!Objects.equals("bd_period", periodField.getString("dimensionsource_id"))) {
            qFilter.and(new QFilter("datasource_type", "!=", (Object)DataSourceTypeEnum.INV_PERIODBALANCE.getCode()));
        }
        return qFilter;
    }

    public void validModelMatchDataSource() {
        Map<String, Object> importInfo = this.getSyncModel().getImportInfo();
        if (importInfo == null || importInfo.isEmpty()) {
            return;
        }
        T source = this.getDataSource();
        ImportSystemSourceTypeEnum importTypeEnum = ((DataSource)source).getType().getImportSystemSourceTypeEnum();
        if (importTypeEnum == null) {
            return;
        }
        if (Objects.equals(importInfo.get("importType"), importTypeEnum)) {
            if (source instanceof BcmDataSource) {
                if (Objects.equals(((BcmDataSource)source).getImportSystemId(), importInfo.get("importSystemId"))) {
                    return;
                }
            } else if (source instanceof EpmDataSource) {
                if (Objects.equals(((EpmDataSource)source).getImportSystemId(), importInfo.get("importSystemId"))) {
                    this.validModelImportDimensionAllinDataSource(importInfo);
                    return;
                }
            } else {
                return;
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u548c\u5206\u6790\u6a21\u578b\u4e2d\u7684\u7ef4\u5ea6/\u5ea6\u91cf\u7684\u5bfc\u5165\u6765\u6e90\u7cfb\u7edf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DataSyncSchema_2", (String)"macc-faf-business", (Object[])new Object[0]));
    }

    private void validModelImportDimensionAllinDataSource(Map<String, Object> importInfo) {
        T source = this.getDataSource();
        if (source instanceof EpmDataSource) {
            List importdimensionLinkList = (List)importInfo.get("importdimensionLinkList");
            List importMeasurenLinkList = (List)importInfo.get("importMeasurenLinkList");
            HashMap<Long, String> idToNameMap = new HashMap<Long, String>();
            for (DynamicObject dimMapping : importdimensionLinkList) {
                idToNameMap.computeIfAbsent(dimMapping.getLong("imdimension"), k -> dimMapping.getString("imdimname"));
            }
            for (DynamicObject meaMapping : importMeasurenLinkList) {
                idToNameMap.computeIfAbsent(meaMapping.getLong("entryimdimension"), k -> meaMapping.getString("entryimdimname"));
            }
            Set<Long> allEpmDimensionIds = ((EpmDataSource)source).getAllEpmDimensionIds();
            Set longSet = idToNameMap.keySet();
            longSet.removeAll(allEpmDimensionIds);
            if (!CollectionUtils.isEmpty(longSet)) {
                String join = StringUtils.join((Object[])longSet.stream().map(idToNameMap::get).toArray(), (String)"\uff0c");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u5305\u542b\u7684\u9884\u7b97\u7ef4\u5ea6(%s)\u5728\u6570\u636e\u6e90\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u5206\u6790\u6a21\u578b\u3002", (String)"DataSyncSchema_3", (String)"macc-faf-business", (Object[])new Object[0]), join));
            }
        }
    }

    public List<ComboItem> getSelectTypeComboItems() {
        return Arrays.asList(SelectTypeEnum.CONDITION.toComboItem(), SelectTypeEnum.CONSTANT.toComboItem(), SelectTypeEnum.MEASUREFIELD.toComboItem());
    }
}

