/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.data;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;

public class EntityProppertyPath {
    private final String name;
    private final String displayName;
    private final Set<Class<?>> excludes = new HashSet();

    public EntityProppertyPath(IDataEntityProperty property) {
        if (property.getParent() instanceof SubEntryType) {
            SubEntryType parent = (SubEntryType)property.getParent();
            EntryType parentParent = (EntryType)parent.getParent();
            String subEntryPropertyName = parentParent.getName() + "." + parent.getName() + "." + property.getName();
            String subEntryPropertyDisplayName = parentParent.getDisplayName() + "." + parent.getDisplayName() + "." + property.getDisplayName();
            this.name = subEntryPropertyName;
            this.displayName = subEntryPropertyDisplayName;
        } else if (property.getParent() instanceof EntryType) {
            EntryType parent = (EntryType)property.getParent();
            String entryPropertyName = parent.getName() + "." + property.getName();
            String entryPropertyDisplayName = parent.getDisplayName() + "." + property.getDisplayName();
            this.name = entryPropertyName;
            this.displayName = entryPropertyDisplayName;
        } else {
            this.name = property.getName();
            this.displayName = property.getDisplayName() + "";
        }
    }

    public EntityProppertyPath(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Set<Class<?>> getExcludes() {
        return this.excludes;
    }

    public boolean isExclude(IDataEntityProperty property) {
        for (Class<?> exclude : this.excludes) {
            if (!property.getClass().isAssignableFrom(exclude)) continue;
            return true;
        }
        return false;
    }

    public EntityProppertyPath nextPath(String endfixName, String endfixDisplay) {
        return new EntityProppertyPath(this.getName() + endfixName, this.getDisplayName() + endfixDisplay);
    }

    public EntityProppertyPath nextPath(String separator, IDataEntityProperty property) {
        EntityProppertyPath proppertyPath = new EntityProppertyPath(this.name + separator + property.getName(), this.getDisplayName() + separator + property.getDisplayName());
        proppertyPath.getExcludes().addAll(this.getExcludes());
        return proppertyPath;
    }
}

