/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.func;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.macc.faf.datasync.exec.impl.BcmSyncDimension;

public class BcmNumberToIdMapFunction
extends MapFunction {
    private static final long serialVersionUID = -1363303285094156478L;
    private final RowMeta resultRowMeta;
    private final Map<Integer, BcmSyncDimension> dimionsionIndexMap;

    public BcmNumberToIdMapFunction(RowMeta rowMeta, Map<String, BcmSyncDimension> dimionsionMap) {
        Field[] fields = rowMeta.getFields();
        Field[] resultFields = new Field[fields.length];
        for (int i = 0; i < resultFields.length; ++i) {
            BcmSyncDimension dimension = dimionsionMap.get(fields[i].getName());
            resultFields[i] = dimension != null ? new Field(dimension.getSourceNumber(), (DataType)DataType.LongType) : fields[i];
        }
        this.dimionsionIndexMap = new LinkedHashMap<Integer, BcmSyncDimension>(dimionsionMap.size());
        Set<Map.Entry<String, BcmSyncDimension>> entrySet = dimionsionMap.entrySet();
        for (Map.Entry<String, BcmSyncDimension> entry : entrySet) {
            this.dimionsionIndexMap.put(rowMeta.getFieldIndex(entry.getKey()), entry.getValue());
        }
        this.resultRowMeta = new RowMeta(resultFields);
    }

    public RowX map(RowX row) {
        Set<Map.Entry<Integer, BcmSyncDimension>> entries = this.dimionsionIndexMap.entrySet();
        for (Map.Entry<Integer, BcmSyncDimension> entry : entries) {
            String number = row.getString(entry.getKey().intValue());
            Object ID = entry.getValue().numberToId(number);
            row.set(entry.getKey().intValue(), ID);
        }
        return row;
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMeta;
    }
}

