/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.func;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.exception.KDBizException;

public class BcmRowToColGroupReduceFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = -7359079388392647512L;
    private final RowMeta resultRowMeta;
    private final List<Integer> index_dimensionCols;
    private final Map<String, Integer> index_membersToMeasure;
    private final String[] grouper;
    private final int index_F_Money;

    public BcmRowToColGroupReduceFunction(RowMeta rowMeta, String[] grouper, Map<Map<String, String>, String> rowTocolMap) {
        this.grouper = grouper;
        this.index_F_Money = rowMeta.getFieldCount() - 1;
        ArrayList<Field> list = new ArrayList<Field>(grouper.length + rowTocolMap.size());
        for (String group : grouper) {
            list.add(new Field(group, (DataType)DataType.StringType));
        }
        this.index_membersToMeasure = new HashMap<String, Integer>(rowTocolMap.size());
        int indexPos = list.size() - 1;
        Set<Map.Entry<Map<String, String>, String>> entries = rowTocolMap.entrySet();
        for (Map.Entry<Map<String, String>, String> entry : entries) {
            list.add(new Field(entry.getValue(), (DataType)DataType.BigDecimalType));
            String collect = String.join((CharSequence)",", entry.getKey().values());
            this.index_membersToMeasure.put(collect, ++indexPos);
        }
        Set<Map<String, String>> maps = rowTocolMap.keySet();
        Iterator<Map<String, String>> iterator = maps.iterator();
        if (!iterator.hasNext()) {
            throw new KDBizException("BcmRowToColGroupReduceFunction rowTocolMap mistake:" + rowTocolMap);
        }
        Map<String, String> next = iterator.next();
        this.index_dimensionCols = next.keySet().stream().map(arg_0 -> ((RowMeta)rowMeta).getFieldIndex(arg_0)).collect(Collectors.toList());
        this.resultRowMeta = new RowMeta(list.toArray(new Field[0]));
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowX rowX = null;
        for (RowX sourceRow : iterable) {
            if (rowX == null) {
                rowX = new RowX(this.resultRowMeta.getFieldCount());
                Object[] values = sourceRow.values();
                for (int i = 0; i < this.grouper.length; ++i) {
                    rowX.set(i, values[i]);
                }
            }
            String collect = this.index_dimensionCols.stream().map(arg_0 -> ((RowX)sourceRow).getString(arg_0)).collect(Collectors.joining(","));
            Integer measureIndex = this.index_membersToMeasure.get(collect);
            rowX.set(measureIndex.intValue(), (Object)sourceRow.getBigDecimal(this.index_F_Money));
        }
        collector.collect(rowX);
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMeta;
    }
}

