/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.macc.faf.datasync.exec.data.CalcMeasure;
import kd.macc.faf.datasync.exec.data.DataExecCalculate;

public class CalcAndComplementCoGroupFunction
extends CoGroupFunction {
    private static final long serialVersionUID = 2495467798521718235L;
    private final int idIndex;
    private final int periodIndex;
    private final int accountIndex;
    private final List<Integer> ordinaryMeasureIndex;
    private final DataExecCalculate calc;
    private final List<CalcMeasure> calcMeasures;

    public CalcAndComplementCoGroupFunction(RowMeta rowMeta, DataExecCalculate dataExecCalculate) {
        this.setSourceRowMeta(rowMeta);
        this.calc = dataExecCalculate;
        this.idIndex = rowMeta.getFieldIndex("id", true);
        this.periodIndex = rowMeta.getFieldIndex(dataExecCalculate.getPeriodNumber(), true);
        this.accountIndex = rowMeta.getFieldIndex(dataExecCalculate.getAccountNumber(), true);
        List<String> ordinaryMeasure = dataExecCalculate.getOrdinaryMeasure();
        this.ordinaryMeasureIndex = new ArrayList<Integer>(ordinaryMeasure.size());
        for (String measure : ordinaryMeasure) {
            this.ordinaryMeasureIndex.add(rowMeta.getFieldIndex(measure, true));
        }
        this.calcMeasures = dataExecCalculate.getCalcMeasureList();
        for (CalcMeasure calcMeasure : this.calcMeasures) {
            calcMeasure.setRowMetaIndex(rowMeta);
        }
    }

    public void coGroup(Iterable<RowX> iter1, Iterable<RowX> iter2, Collector collector) {
        Iterator<RowX> iterator1 = iter1.iterator();
        Iterator<RowX> iterator2 = iter2.iterator();
        RowX rowX1 = iterator1.hasNext() ? iterator1.next() : null;
        RowX rowX2 = this.sumRowXCalcMeasures(iterator2);
        if (rowX1 == null && rowX2 != null) {
            RowX copy = rowX2.copy();
            copy.set(0, (Object)DB.genGlobalLongId());
            copy.set(this.periodIndex, (Object)this.calc.getPeriodId());
            for (Integer index : this.ordinaryMeasureIndex) {
                copy.set(index.intValue(), (Object)BigDecimal.ZERO);
            }
            this.calcRow(copy, rowX2);
            if (this.allCalcMeasureIsZero(copy)) {
                return;
            }
            collector.collect(copy);
            return;
        }
        if (rowX1 != null) {
            this.calcRow(rowX1, rowX2);
            collector.collect(rowX1);
        }
    }

    private boolean allCalcMeasureIsZero(RowX rowX) {
        for (CalcMeasure calcMeasure : this.calcMeasures) {
            BigDecimal val = rowX.getBigDecimal(calcMeasure.getIndex().intValue());
            if (val != null && val.compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        return true;
    }

    private void calcRow(RowX pRow, RowX preRow) {
        for (CalcMeasure calcMeasure : this.calcMeasures) {
            BigDecimal val = this.safeGet(pRow, calcMeasure.getLinkIndex());
            if (calcMeasure.getMatch().booleanValue()) {
                val = StringUtils.isBlank((CharSequence)calcMeasure.getDimensionattrnb()) && this.calc.isPltype0(pRow.getLong(this.accountIndex)) ? val.add(this.safeGet(preRow, calcMeasure.getIndex())) : (StringUtils.isNotBlank((CharSequence)calcMeasure.getDimensionattrnb()) ? val.add(this.safeGet(preRow, calcMeasure.getIndex())) : BigDecimal.ZERO);
            }
            pRow.set(calcMeasure.getIndex().intValue(), (Object)val);
        }
    }

    public BigDecimal safeGet(RowX rowX, Integer index) {
        if (rowX == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal val = rowX.getBigDecimal(index.intValue());
        if (val == null) {
            return BigDecimal.ZERO;
        }
        return val;
    }

    private RowX sumRowXCalcMeasures(Iterator<RowX> iterator) {
        if (iterator == null || !iterator.hasNext()) {
            return null;
        }
        RowX first = iterator.next();
        Long firstRowId = first.getLong(this.idIndex);
        while (iterator.hasNext()) {
            RowX next = iterator.next();
            Long nextRowId = next.getLong(this.idIndex);
            if (firstRowId.longValue() == nextRowId.longValue()) continue;
            for (CalcMeasure calcMeasure : this.calcMeasures) {
                int calcMeasureIndex = calcMeasure.getIndex();
                BigDecimal sumValue = this.safeGet(first, calcMeasureIndex).add(this.safeGet(next, calcMeasureIndex));
                first.set(calcMeasureIndex, (Object)sumValue);
            }
        }
        return first;
    }

    public RowMeta getResultRowMeta() {
        return this.getSourceRowMeta();
    }
}

