/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.func;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;
import kd.macc.faf.util.AnalysisModelHashUtil;

public class FillDimensionHashMapFunction
extends MapFunction {
    private static final long serialVersionUID = 5702229097907899630L;
    private final RowMeta rowMeta;
    private final List<Integer> dimensionIndexs;
    private final int hashIndex;

    public FillDimensionHashMapFunction(RowMeta rowMeta, List<String> dimensions) {
        this.rowMeta = rowMeta;
        this.hashIndex = rowMeta.getFieldIndex("dimhash", false);
        this.dimensionIndexs = new ArrayList<Integer>(dimensions.size());
        for (String dimension : dimensions) {
            this.dimensionIndexs.add(rowMeta.getFieldIndex(dimension, false));
        }
    }

    public RowX map(RowX rowX) {
        String hashV;
        if (this.hashIndex > 0 && StringUtils.isBlank((String)(hashV = rowX.getString(this.hashIndex)))) {
            rowX.set(this.hashIndex, (Object)AnalysisModelHashUtil.calculateDimHash((RowX)rowX, this.dimensionIndexs));
        }
        return rowX;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

