/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.bos.db.DB;

public class IncrementSummaryCoGroupFunction
extends CoGroupFunction {
    private static final long serialVersionUID = 1L;
    private final RowMeta resultRowMeta;
    private final List<Integer> orginalMeasureIndexList;
    private final List<Integer> fieldsIndexList;
    private final int index_collectstatus;
    private final int index_operationstatus;
    private final int index_summaryid;
    private final int index_hash;

    public IncrementSummaryCoGroupFunction(RowMeta rowMeta, List<String> fields, List<String> ordinaryMeasure) {
        this.setSourceRowMeta(rowMeta);
        this.fieldsIndexList = new ArrayList<Integer>(fields.size());
        for (String field : fields) {
            this.fieldsIndexList.add(rowMeta.getFieldIndex(field));
        }
        this.orginalMeasureIndexList = new ArrayList<Integer>(ordinaryMeasure.size());
        for (String field : ordinaryMeasure) {
            this.orginalMeasureIndexList.add(rowMeta.getFieldIndex(field));
        }
        this.index_collectstatus = rowMeta.getFieldIndex("collectstatus", true);
        this.index_operationstatus = rowMeta.getFieldIndex("operationstatus", true);
        this.index_summaryid = rowMeta.getFieldIndex("summaryid", true);
        this.resultRowMeta = this.getSourceRowMeta();
        this.index_hash = rowMeta.getFieldIndex("dimhash", false);
    }

    public void coGroup(Iterable<RowX> iter1, Iterable<RowX> iter2, Collector collector) {
        RowX coRow = new RowX(this.resultRowMeta.getFieldCount());
        Iterator<RowX> iterator2 = iter2.iterator();
        if (iterator2.hasNext()) {
            RowX next = iterator2.next();
            coRow.set(0, next.get(0));
            for (Integer index : this.fieldsIndexList) {
                coRow.set(index.intValue(), next.get(index.intValue()));
            }
            for (Integer measureIndex : this.orginalMeasureIndexList) {
                coRow.set(measureIndex.intValue(), (Object)BigDecimal.ZERO);
            }
            if (this.index_hash > 0) {
                coRow.set(this.index_hash, next.get(this.index_hash));
            }
            coRow.set(this.index_summaryid, (Object)0L);
        } else {
            coRow.set(0, (Object)DB.genGlobalLongId());
            for (Integer measureIndex : this.orginalMeasureIndexList) {
                coRow.set(measureIndex.intValue(), (Object)BigDecimal.ZERO);
            }
            coRow.set(this.index_summaryid, (Object)1L);
        }
        Iterator<RowX> iterator1 = iter1.iterator();
        if (iterator1.hasNext()) {
            RowX next = iterator1.next();
            for (Integer index : this.fieldsIndexList) {
                coRow.set(index.intValue(), next.get(index.intValue()));
            }
            if (this.index_hash > 0) {
                coRow.set(this.index_hash, next.get(this.index_hash));
            }
            this.collectorDetailRow(collector, coRow, next);
        } else {
            return;
        }
        while (iterator1.hasNext()) {
            this.collectorDetailRow(collector, coRow, iterator1.next());
        }
        coRow.set(this.index_operationstatus, (Object)0L);
        coRow.set(this.index_collectstatus, (Object)1L);
        collector.collect(coRow);
    }

    private void collectorDetailRow(Collector collector, RowX coRow, RowX next) {
        for (Integer measureIndex : this.orginalMeasureIndexList) {
            coRow.set(measureIndex.intValue(), (Object)this.safeGet(next, measureIndex).add(this.safeGet(coRow, measureIndex)));
        }
        next.set(this.index_summaryid, coRow.get(0));
        collector.collect(next);
    }

    public BigDecimal safeGet(RowX rowX, Integer index) {
        if (rowX == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal val = rowX.getBigDecimal(index.intValue());
        if (val == null) {
            return BigDecimal.ZERO;
        }
        return val;
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMeta;
    }
}

