/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.func;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.macc.faf.datasync.exec.data.DataExecSummary;
import kd.macc.faf.datasync.exec.data.DataSyncModel;

public class IncrementSummaryGroupReduceFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 5474367587159907253L;
    private final int index_hash;
    private final DataExecSummary syncSummary;

    public IncrementSummaryGroupReduceFunction(RowMeta rowMeta, DataExecSummary syncSummary) {
        this.setSourceRowMeta(rowMeta);
        this.syncSummary = syncSummary;
        this.index_hash = rowMeta.getFieldIndex("dimhash", true);
    }

    public void reduce(Iterable<RowX> iter, Collector collector) {
        HashSet<String> hashValSet = new HashSet<String>();
        hashValSet.add(" ");
        for (RowX rowX : iter) {
            hashValSet.add(rowX.getString(this.index_hash));
            if (hashValSet.size() <= 5000) continue;
            this.queryDataSet(collector, hashValSet);
            hashValSet = new HashSet();
        }
        if (!hashValSet.isEmpty()) {
            this.queryDataSet(collector, hashValSet);
            hashValSet.clear();
        }
    }

    private void queryDataSet(Collector collector, Set<String> hashValSet) {
        DataSyncModel model = this.syncSummary.getModel();
        String entitynumber = model.getEntitynumber();
        String selectFields = model.getSelectFields();
        QFilter qFilter = new QFilter("dimhash", "in", hashValSet).and(this.syncSummary.getPeriodQFilter(true));
        try (DataSet dataSet = ORM.create().queryDataSet("algox-increment-summary", entitynumber, selectFields, qFilter.toArray());){
            DataSet addField = dataSet.addField("0", "summaryid");
            for (Row row : addField) {
                collector.collect(new RowX(((AbstractRow)row).values()));
            }
        }
    }

    public RowMeta getResultRowMeta() {
        return this.getSourceRowMeta();
    }
}

