/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;

public class InvMeasureValueMapFunction
extends MapFunction {
    private static final long serialVersionUID = 5689510813399205656L;
    private static final String PERIOD_NUMBER = "period";
    private static final String ENDPERIOD_NUMBER = "endperiod";
    private final RowMeta rowMeta;
    private final RowMeta newRowMeta;
    private final Long period;
    private final Integer periodInteger;
    private final Map<Integer, Integer> mapping_a = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> mapping_b = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> mapping_c = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> mapping_d = new HashMap<Integer, Integer>();

    public InvMeasureValueMapFunction(RowMeta rowMeta, Set<String> sourceMeasures, Long period, Integer periodInteger) {
        this.rowMeta = rowMeta;
        this.period = period;
        this.periodInteger = periodInteger;
        Field[] fields = rowMeta.getFields();
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : fields) {
            if (Objects.equals(field.getName(), ENDPERIOD_NUMBER)) continue;
            if (Objects.equals(field.getName(), PERIOD_NUMBER)) {
                list.add(new Field(PERIOD_NUMBER, (DataType)DataType.LongType));
                continue;
            }
            list.add(new Field(field.getName(), field.getDataType()));
        }
        if (sourceMeasures.contains("qty")) {
            list.add(new Field("qty", (DataType)DataType.BigDecimalType));
        }
        if (sourceMeasures.contains("baseqty")) {
            list.add(new Field("baseqty", (DataType)DataType.BigDecimalType));
        }
        if (sourceMeasures.contains("qty2nd")) {
            list.add(new Field("qty2nd", (DataType)DataType.BigDecimalType));
        }
        this.newRowMeta = new RowMeta(list.toArray(new Field[0]));
        this.putMapping(this.mapping_a, sourceMeasures, "qty", "qty_bal");
        this.putMapping(this.mapping_a, sourceMeasures, "baseqty", "baseqty_bal");
        this.putMapping(this.mapping_a, sourceMeasures, "qty2nd", "qty2nd_bal");
        this.putMapping(this.mapping_b, sourceMeasures, "qty_in", "qty_in");
        this.putMapping(this.mapping_b, sourceMeasures, "baseqty_in", "baseqty_in");
        this.putMapping(this.mapping_b, sourceMeasures, "qty2nd_in", "qty2nd_in");
        this.putMapping(this.mapping_b, sourceMeasures, "qty_out", "qty_out");
        this.putMapping(this.mapping_b, sourceMeasures, "baseqty_out", "baseqty_out");
        this.putMapping(this.mapping_b, sourceMeasures, "qty2nd_out", "qty2nd_out");
        this.putMapping(this.mapping_c, sourceMeasures, "qty_bal", "qty_bal");
        this.putMapping(this.mapping_c, sourceMeasures, "baseqty_bal", "baseqty_bal");
        this.putMapping(this.mapping_c, sourceMeasures, "qty2nd_bal", "qty2nd_bal");
        Field[] newRowMetaFields = this.newRowMeta.getFields();
        for (int i = 0; i < newRowMetaFields.length; ++i) {
            Field f = newRowMetaFields[i];
            if (Objects.equals(f.getName(), PERIOD_NUMBER) || sourceMeasures.contains(f.getName())) continue;
            this.mapping_d.put(i, rowMeta.getFieldIndex(f.getName()));
        }
    }

    private void putMapping(Map<Integer, Integer> mapping, Set<String> set, String nR, String r) {
        if (set.contains(nR)) {
            mapping.put(this.newRowMeta.getFieldIndex(nR, false), this.rowMeta.getFieldIndex(r, false));
        }
    }

    public RowX map(RowX rowX) {
        RowX newRow = new RowX(this.newRowMeta.getFieldCount());
        newRow.set(this.newRowMeta.getFieldIndex(PERIOD_NUMBER), (Object)this.period);
        this.copyRow(newRow, rowX, this.mapping_d);
        Integer p = rowX.getInteger(this.rowMeta.getFieldIndex(PERIOD_NUMBER));
        Integer endp = rowX.getInteger(this.rowMeta.getFieldIndex(ENDPERIOD_NUMBER));
        if (p < this.periodInteger && this.periodInteger <= endp) {
            this.copyRow(newRow, rowX, this.mapping_a);
        }
        if (p.equals(this.periodInteger)) {
            this.copyRow(newRow, rowX, this.mapping_b);
        }
        if (p <= this.periodInteger && this.periodInteger < endp) {
            this.copyRow(newRow, rowX, this.mapping_c);
        }
        if (this.allEmpty(newRow)) {
            newRow.set(0, (Object)0L);
        }
        return newRow;
    }

    private boolean allEmpty(RowX newRow) {
        BigDecimal bigDecimal;
        for (Integer i : this.mapping_a.keySet()) {
            bigDecimal = newRow.getBigDecimal(i.intValue());
            if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        for (Integer i : this.mapping_b.keySet()) {
            bigDecimal = newRow.getBigDecimal(i.intValue());
            if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        for (Integer i : this.mapping_c.keySet()) {
            bigDecimal = newRow.getBigDecimal(i.intValue());
            if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        return true;
    }

    private void copyRow(RowX newRow, RowX rowX, Map<Integer, Integer> mapping) {
        Set<Map.Entry<Integer, Integer>> entries = mapping.entrySet();
        for (Map.Entry<Integer, Integer> entry : entries) {
            if (entry.getKey() < 0 || entry.getValue() < 0) continue;
            newRow.set(entry.getKey().intValue(), rowX.get(entry.getValue().intValue()));
        }
    }

    public RowMeta getResultRowMeta() {
        return this.newRowMeta;
    }
}

