/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.func;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.exception.KDBizException;
import kd.macc.faf.datasync.exec.data.DataSyncTransfer;

public class MultiEntryClearMapFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = -6528044827391422282L;
    private final RowMeta resultRowMeta;
    private final List<DataSyncTransfer> dataTransfers;
    private final int entryIdIndex;
    private final int maxLevel;

    public MultiEntryClearMapFunction(RowMeta rowMeta, List<DataSyncTransfer> dataTransfers) {
        this.resultRowMeta = rowMeta;
        this.dataTransfers = dataTransfers;
        this.maxLevel = !dataTransfers.isEmpty() ? dataTransfers.get(0).getMaxEntryLevel() : 0;
        this.entryIdIndex = rowMeta.getFieldIndex("_entryid_dim");
        if (this.maxLevel == 2 && this.entryIdIndex == -1) {
            throw new KDBizException("multi entry clear, entryid Index not exsit.");
        }
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowX next;
        Iterator<RowX> iterator = iterable.iterator();
        HashSet<Long> entityIdSet = new HashSet<Long>();
        if (iterator.hasNext()) {
            next = iterator.next();
            if (this.maxLevel == 2) {
                entityIdSet.add(next.getLong(this.entryIdIndex));
            }
            collector.collect(next);
        }
        while (iterator.hasNext()) {
            next = iterator.next();
            for (DataSyncTransfer syncTransfer : this.dataTransfers) {
                int entryLevel = syncTransfer.getEntryLevel();
                if (entryLevel == 0) {
                    next.set(syncTransfer.getSourceFieldNameIndex().intValue(), (Object)BigDecimal.ZERO);
                }
                if (this.maxLevel != 2 || entryLevel != 1) continue;
                Long aLong = next.getLong(this.entryIdIndex);
                if (entityIdSet.contains(aLong)) {
                    next.set(syncTransfer.getSourceFieldNameIndex().intValue(), (Object)BigDecimal.ZERO);
                    continue;
                }
                entityIdSet.add(aLong);
            }
            collector.collect(next);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMeta;
    }
}

