/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.orm.util.CollectionUtils;
import kd.macc.faf.datasync.exec.data.CalcMeasure;
import kd.macc.faf.datasync.exec.data.DataExecCalculate;

public class RecalcAndComplementCoGroupFunction
extends CoGroupFunction {
    private static final long serialVersionUID = 7740517448697141361L;
    private final int idIndex;
    private final int periodIndex;
    private final int accountIndex;
    private final int dbFlagIndex;
    private final List<Integer> ordinaryMeasureIndex;
    private final DataExecCalculate calc;
    private final List<CalcMeasure> calcMeasures;

    public RecalcAndComplementCoGroupFunction(RowMeta rowMeta, DataExecCalculate dataExecCalculate) {
        this.setSourceRowMeta(rowMeta);
        this.calc = dataExecCalculate;
        this.idIndex = rowMeta.getFieldIndex("id", true);
        this.periodIndex = rowMeta.getFieldIndex(dataExecCalculate.getPeriodNumber(), true);
        this.accountIndex = rowMeta.getFieldIndex(dataExecCalculate.getAccountNumber(), true);
        this.dbFlagIndex = rowMeta.getFieldIndex("_dbflag", true);
        List<String> ordinaryMeasure = dataExecCalculate.getOrdinaryMeasure();
        this.ordinaryMeasureIndex = new ArrayList<Integer>(ordinaryMeasure.size());
        for (String measure : ordinaryMeasure) {
            this.ordinaryMeasureIndex.add(rowMeta.getFieldIndex(measure, true));
        }
        this.calcMeasures = dataExecCalculate.getCalcMeasureList();
        for (CalcMeasure calcMeasure : this.calcMeasures) {
            calcMeasure.setRowMetaIndex(rowMeta);
        }
    }

    public void coGroup(Iterable<RowX> iter1, Iterable<RowX> iter2, Collector collector) {
        RowX rowX1 = this.recalcMeasuresAndCollect(iter1, collector);
        RowX rowX2 = this.sumRowXCalcMeasures(iter2);
        if (rowX1 == null && rowX2 != null) {
            RowX copy = rowX2.copy();
            copy.set(0, (Object)DB.genGlobalLongId());
            copy.set(this.periodIndex, (Object)this.calc.getPeriodId());
            for (Integer index : this.ordinaryMeasureIndex) {
                copy.set(index.intValue(), (Object)BigDecimal.ZERO);
            }
            this.calcRow(copy, rowX2);
            if (this.allCalcMeasureIsZero(copy)) {
                return;
            }
            copy.set(this.dbFlagIndex, (Object)1);
            collector.collect(copy);
        }
        if (rowX1 != null) {
            this.sumRowXCalcMeasures(Arrays.asList(rowX1, rowX2));
            rowX1.set(this.dbFlagIndex, (Object)2);
            collector.collect(rowX1);
        }
    }

    private boolean allCalcMeasureIsZero(RowX rowX) {
        for (CalcMeasure calcMeasure : this.calcMeasures) {
            BigDecimal val = rowX.getBigDecimal(calcMeasure.getIndex().intValue());
            if (val != null && val.compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        return true;
    }

    private void calcRow(RowX pRow, RowX preRow) {
        for (CalcMeasure calcMeasure : this.calcMeasures) {
            BigDecimal val = this.safeGet(pRow, calcMeasure.getLinkIndex());
            if (calcMeasure.getMatch().booleanValue()) {
                val = StringUtils.isBlank((CharSequence)calcMeasure.getDimensionattrnb()) && this.calc.isPltype0(pRow.getLong(this.accountIndex)) ? val.add(this.safeGet(preRow, calcMeasure.getIndex())) : (StringUtils.isNotBlank((CharSequence)calcMeasure.getDimensionattrnb()) ? val.add(this.safeGet(preRow, calcMeasure.getIndex())) : BigDecimal.ZERO);
            }
            pRow.set(calcMeasure.getIndex().intValue(), (Object)val);
        }
    }

    public BigDecimal safeGet(RowX rowX, Integer index) {
        if (rowX == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal val = rowX.getBigDecimal(index.intValue());
        if (val == null) {
            return BigDecimal.ZERO;
        }
        return val;
    }

    private RowX sumRowXCalcMeasures(Iterable<RowX> iterable) {
        ArrayList<RowX> rowXList = new ArrayList<RowX>(1);
        for (RowX rowX : iterable) {
            rowXList.add(rowX);
        }
        return this.sumRowXCalcMeasures((List<RowX>)rowXList);
    }

    private RowX sumRowXCalcMeasures(List<RowX> rowXList) {
        if (CollectionUtils.isEmpty(rowXList)) {
            return null;
        }
        RowX first = rowXList.get(0);
        for (int i = 1; i < rowXList.size(); ++i) {
            RowX current = rowXList.get(i);
            for (CalcMeasure calcMeasure : this.calcMeasures) {
                int calcMeasureIndex = calcMeasure.getIndex();
                BigDecimal sumValue = this.safeGet(first, calcMeasureIndex).add(this.safeGet(current, calcMeasureIndex));
                first.set(calcMeasureIndex, (Object)sumValue);
            }
        }
        return first;
    }

    private RowX recalcMeasuresAndCollect(Iterable<RowX> iterable, Collector collector) {
        ArrayList<RowX> rowXList = new ArrayList<RowX>(1);
        for (RowX rowX : iterable) {
            rowXList.add(rowX);
        }
        if (rowXList.isEmpty()) {
            return null;
        }
        rowXList.sort((o1, o2) -> o2.getLong(this.idIndex).compareTo(o1.getLong(this.idIndex)));
        RowX maxIdRowX = (RowX)rowXList.get(0);
        this.calcRow(maxIdRowX, null);
        for (int i = 1; i < rowXList.size(); ++i) {
            RowX current = (RowX)rowXList.get(i);
            this.calcRow(current, null);
            for (CalcMeasure calcMeasure : this.calcMeasures) {
                int calcMeasureIndex = calcMeasure.getIndex();
                BigDecimal sumValue = this.safeGet(maxIdRowX, calcMeasureIndex).add(this.safeGet(current, calcMeasureIndex));
                maxIdRowX.set(calcMeasureIndex, (Object)sumValue);
                current.set(calcMeasureIndex, (Object)BigDecimal.ZERO);
            }
            current.set(this.dbFlagIndex, (Object)2);
            collector.collect(current);
        }
        return maxIdRowX;
    }

    public RowMeta getResultRowMeta() {
        return this.getSourceRowMeta();
    }
}

