/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.func;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.LogFactory;
import kd.macc.faf.datasync.exec.data.DataSyncCondition;
import kd.macc.faf.datasync.exec.data.DataSyncTransfer;

public class SyncConditionMapFunction
extends MapFunction {
    private static final long serialVersionUID = -9111964151902900400L;
    private final DataSyncCondition dataSyncCondition;

    public SyncConditionMapFunction(RowMeta rowMeta, DataSyncCondition dataSyncCondition) {
        this.setSourceRowMeta(rowMeta);
        this.dataSyncCondition = dataSyncCondition;
    }

    public DataSyncCondition getDataSyncCondition() {
        this.dataSyncCondition.prepare(this.getSourceRowMeta());
        return this.dataSyncCondition;
    }

    public RowX map(RowX row) {
        DataSyncCondition syncCondition = this.getDataSyncCondition();
        Set<String> conditionFields = this.getDataSyncCondition().getConditionFields();
        for (String fieldKey : conditionFields) {
            FilterCondition filterCondition = syncCondition.getFilterCondition(fieldKey);
            if (filterCondition == null) continue;
            int targetFieldIndex = this.getSourceRowMeta().getFieldIndex(fieldKey);
            DataType targetDataType = this.getSourceRowMeta().getDataType(targetFieldIndex);
            List filterRow = filterCondition.getFilterRow();
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            boolean alwaysFalse = false;
            for (SimpleFilterRow simpleFilterRow : filterRow) {
                Object val;
                String fieldName = simpleFilterRow.getFieldName();
                if (fieldName.contains(".")) {
                    DataSyncTransfer dataSyncTransfer = syncCondition.getDataSyncTransfer(fieldName);
                    val = dataSyncTransfer.transferToValue(row);
                    ctx.put(fieldName, val);
                } else {
                    int fieldIndex = this.getSourceRowMeta().getFieldIndex(fieldName);
                    DataType dataType = this.getSourceRowMeta().getDataType(fieldIndex);
                    val = row.get(fieldIndex);
                    if (DataType.BigDecimalType.equals((Object)dataType) && val == null) {
                        alwaysFalse = true;
                        break;
                    }
                }
                ctx.put(fieldName, val);
            }
            if (alwaysFalse) {
                row.set(targetFieldIndex, this.nullValue(targetDataType));
                continue;
            }
            String formulaStr = syncCondition.getFormulaStr(fieldKey);
            try {
                Object object;
                if (!StringUtils.isNotBlank((CharSequence)formulaStr) || !((object = FormulaEngine.execExcelFormula((String)formulaStr, ctx)) instanceof Boolean) || ((Boolean)object).booleanValue()) continue;
                row.set(targetFieldIndex, this.nullValue(targetDataType));
            }
            catch (Exception e) {
                LogFactory.getLog(SyncConditionMapFunction.class).error((Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("algox_func_erro", String.format("formula:%1$s,ctx:%2$s", formulaStr, ctx)), new Object[0]);
            }
        }
        return row;
    }

    private Object nullValue(DataType dataType) {
        if (DataType.LongType.equals((Object)dataType)) {
            return 0L;
        }
        if (DataType.StringType.equals((Object)dataType)) {
            return " ";
        }
        return null;
    }

    public RowMeta getResultRowMeta() {
        return this.getSourceRowMeta();
    }
}

