/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.db.DB;

public class SyncDataToSumGroupReduceFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private final RowMeta rowMeta;
    private final List<Integer> orginalMeasureIndex;
    private final int summaryIdIndex;
    private final int operationstatusIndex;
    private final int collectstatusIndex;

    public SyncDataToSumGroupReduceFunction(RowMeta rowMeta, List<String> ordinaryMeasure) {
        this.rowMeta = rowMeta;
        this.orginalMeasureIndex = new ArrayList<Integer>(ordinaryMeasure.size());
        for (String omNumber : ordinaryMeasure) {
            this.orginalMeasureIndex.add(rowMeta.getFieldIndex(omNumber));
        }
        this.summaryIdIndex = rowMeta.getFieldIndex("summaryid");
        this.operationstatusIndex = rowMeta.getFieldIndex("operationstatus");
        this.collectstatusIndex = rowMeta.getFieldIndex("collectstatus");
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        HashMap<Integer, BigDecimal> calMap = new HashMap<Integer, BigDecimal>();
        RowX sumRowX = null;
        long summaryId = DB.genGlobalLongId();
        for (RowX row : iterable) {
            if (sumRowX == null) {
                sumRowX = row.copy();
                sumRowX.set(0, (Object)summaryId);
                sumRowX.set(this.summaryIdIndex, (Object)1L);
            }
            row.set(this.summaryIdIndex, (Object)summaryId);
            collector.collect(row);
            for (Integer index : this.orginalMeasureIndex) {
                BigDecimal bigDecimal = row.getBigDecimal(index.intValue());
                if (bigDecimal == null) continue;
                BigDecimal orDefault = calMap.getOrDefault(index, BigDecimal.ZERO);
                calMap.put(index, orDefault.add(bigDecimal));
            }
        }
        if (sumRowX == null) {
            return;
        }
        for (Integer index : this.orginalMeasureIndex) {
            BigDecimal orDefault = calMap.getOrDefault(index, BigDecimal.ZERO);
            sumRowX.set(index.intValue(), (Object)orDefault);
        }
        sumRowX.set(this.operationstatusIndex, (Object)0L);
        sumRowX.set(this.collectstatusIndex, (Object)1L);
        collector.collect(sumRowX);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

