/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.func;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.macc.faf.datasync.exec.data.DataSyncTransfer;
import kd.macc.faf.datasync.exec.func.SyncTransferSort;

public class SyncMapFunction
extends MapFunction {
    private static final long serialVersionUID = -6528044827391422282L;
    private final RowMeta resultRowMeta;
    private final List<DataSyncTransfer> dataTransfers;

    public SyncMapFunction(RowMeta rowMeta, List<DataSyncTransfer> dataTransfers) {
        this.setSourceRowMeta(rowMeta);
        ArrayList<Field> list = new ArrayList<Field>(dataTransfers.size());
        list.add(new Field("id", (DataType)DataType.LongType));
        int index = list.size();
        for (DataSyncTransfer syncTransfer : dataTransfers) {
            syncTransfer.setIndex(index++);
            list.add(new Field(syncTransfer.getFieldName(), syncTransfer.getDataType()));
            String sourceFieldName = syncTransfer.getSourceFieldName();
            if (!StringUtils.isNotEmpty((CharSequence)sourceFieldName)) continue;
            if (sourceFieldName.startsWith("dim_")) {
                sourceFieldName = "_entryid_" + sourceFieldName;
            } else {
                String flexfield = syncTransfer.getFlexfield();
                if (StringUtils.isNotEmpty((CharSequence)flexfield)) {
                    sourceFieldName = sourceFieldName + "_" + flexfield;
                }
            }
            syncTransfer.setSourceFieldNameIndex(rowMeta.getFieldIndex(sourceFieldName, true));
            String sourceFieldTypePropName = syncTransfer.getSourceFieldTypePropName();
            if (!StringUtils.isNotBlank((CharSequence)sourceFieldTypePropName)) continue;
            syncTransfer.setSourceFieldTypePropNameIndex(rowMeta.getFieldIndex(sourceFieldTypePropName, true));
        }
        this.resultRowMeta = new RowMeta(list.toArray(new Field[0]));
        for (DataSyncTransfer dataTransfer : dataTransfers) {
            if (!"2".equals(dataTransfer.getTransferType()) && !"4".equals(dataTransfer.getTransferType())) continue;
            List<String> sourceFields = dataTransfer.getSourceFields();
            RowMeta indexRowMeta = "4".equals(dataTransfer.getTransferType()) ? rowMeta : this.resultRowMeta;
            List<Integer> indexs = sourceFields.stream().map(arg_0 -> ((RowMeta)indexRowMeta).getFieldIndex(arg_0)).collect(Collectors.toList());
            dataTransfer.setSourceFieldsIndex(indexs);
        }
        this.dataTransfers = new SyncTransferSort(dataTransfers).getsort();
    }

    public RowX map(RowX row) {
        RowX resultRowX = new RowX(this.resultRowMeta.getFieldCount());
        resultRowX.set(0, (Object)DB.genGlobalLongId());
        for (DataSyncTransfer syncTransfer : this.dataTransfers) {
            syncTransfer.transfer(row, resultRowX);
        }
        return resultRowX;
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMeta;
    }
}

