/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.macc.faf.datasource.DatasourceServiceHelper;
import kd.macc.faf.datasource.dto.LoadMemberDTO;
import kd.macc.faf.datasync.exec.data.DataSyncDimension;
import kd.macc.faf.olap.OlapServerDimMemberMetaInfo;

public class BcmSyncDimension
extends DataSyncDimension {
    private static final long serialVersionUID = -8814427511421570104L;
    private Long cmmodel;
    private Long sDimensionId;
    private String sDimensionEntityname;
    private Map<Object, String> idToNumber;
    private Map<String, Object> numberToId;

    public BcmSyncDimension(DynamicObject dynamic) {
        super(dynamic);
    }

    private void loadNumberToId() {
        if (this.idToNumber == null) {
            LoadMemberDTO dto = new LoadMemberDTO();
            dto.setModelId(this.cmmodel);
            dto.setDimId(this.sDimensionId);
            dto.setDimNumber(this.getSourceNumber());
            dto.setDimEntityName(this.sDimensionEntityname);
            Map<String, OlapServerDimMemberMetaInfo> metaInfoMap = DatasourceServiceHelper.loadDimensionMembers(dto);
            Collection<OlapServerDimMemberMetaInfo> values = metaInfoMap.values();
            this.numberToId = new HashMap<String, Object>(values.size());
            for (OlapServerDimMemberMetaInfo value : values) {
                if ("3".equals(value.getStorageType())) continue;
                this.numberToId.put(value.getNumber(), value.getId());
            }
        } else {
            Set<Map.Entry<Object, String>> entries = this.idToNumber.entrySet();
            this.numberToId = new HashMap<String, Object>(entries.size());
            for (Map.Entry<Object, String> entry : entries) {
                this.numberToId.put(entry.getValue(), entry.getKey());
            }
        }
    }

    public void setCmmodel(Long cmmodel) {
        this.cmmodel = cmmodel;
    }

    public void setsDimensionId(Long sDimensionId) {
        this.sDimensionId = sDimensionId;
    }

    public void setsDimensionEntityname(String sDimensionEntityname) {
        this.sDimensionEntityname = sDimensionEntityname;
    }

    public Map<Object, String> loadIdToNumberMap(Collection<Object> ids) {
        QFilter filter = new QFilter("dimension", "=", (Object)this.sDimensionId).and(new QFilter("id", "in", ids)).and(new QFilter("status", "=", (Object)"C")).and(new QFilter("enable", "=", (Object)"1"));
        ORM orm = ORM.create();
        try (DataSet dataSet = orm.queryDataSet("BcmSyncDimension.loadIdToNumberMap", this.sDimensionEntityname, "id,number", filter.toArray());){
            Map<Object, String> idToNumber = StreamSupport.stream(Spliterators.spliteratorUnknownSize(dataSet.iterator(), 4), false).collect(Collectors.toMap(row -> row.get("id"), row -> row.getString("number")));
            this.idToNumber = idToNumber;
            Map<Object, String> map = idToNumber;
            return map;
        }
    }

    public Object numberToId(String number) {
        if (this.numberToId == null) {
            this.loadNumberToId();
        }
        return this.numberToId.get(number);
    }
}

