/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.impl;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.macc.faf.datasync.exec.data.DataSync;
import kd.macc.faf.datasync.exec.input.bcm.BcmApiFilter;

public class BcmSyncMeasure
extends DataSync {
    private static final long serialVersionUID = -8814427511421570104L;
    private final Set<BcmApiFilter> filters = new LinkedHashSet<BcmApiFilter>();

    public BcmSyncMeasure(DynamicObject dynamic) {
        super(dynamic);
        QFilter qfilter = new QFilter("measure", "=", dynamic.getPkValue());
        try (DataSet dataSet = ORM.create().queryDataSet("BcmSyncMeasure_new", "faf_cmmeasuremapping", "measure,entryentity.cmdimnumber,entryentity.membernumber", qfilter.toArray());){
            for (Row row : dataSet) {
                String bcmDimesionnumber = row.getString("entryentity.cmdimnumber");
                String bcmMembernumber = row.getString("entryentity.membernumber");
                BcmApiFilter bcmApiFilter = new BcmApiFilter(bcmDimesionnumber, "10");
                bcmApiFilter.getVal().add(bcmMembernumber);
                this.filters.add(bcmApiFilter);
            }
        }
    }

    public Set<BcmApiFilter> getFilters() {
        return this.filters;
    }

    public List<String> getBcmDimensionNumbers() {
        return this.filters.stream().map(BcmApiFilter::getDim).collect(Collectors.toList());
    }

    public Map<String, String> getMembersMap() {
        return this.filters.stream().collect(Collectors.toMap(new Function<BcmApiFilter, String>(){

            @Override
            public String apply(BcmApiFilter bcmApiFilter) {
                return bcmApiFilter.getDim();
            }
        }, new Function<BcmApiFilter, String>(){

            @Override
            public String apply(BcmApiFilter bcmApiFilter) {
                List<String> val = bcmApiFilter.getVal();
                if (val.size() == 1) {
                    return val.get(0);
                }
                return null;
            }
        }));
    }
}

