/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.macc.faf.datasource.dynamic.BcmDataSource;
import kd.macc.faf.datasource.dynamic.DataSource;
import kd.macc.faf.datasync.exec.data.DataSync;
import kd.macc.faf.datasync.exec.data.DataSyncDimension;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.datasync.exec.data.DataSyncParams;
import kd.macc.faf.datasync.exec.impl.BcmSyncDimension;
import kd.macc.faf.datasync.exec.impl.BcmSyncMeasure;
import kd.macc.faf.datasync.exec.impl.NoEntitySyncSchema;
import kd.macc.faf.datasync.exec.input.bcm.BCMCustomizedInput;
import kd.macc.faf.datasync.exec.input.bcm.BcmApiFilter;
import kd.macc.faf.datasync.exec.input.bcm.BcmApiRequest;

public class BcmSyncSchema
extends NoEntitySyncSchema<BcmDataSource> {
    private static final long serialVersionUID = -2294932806082469384L;
    private final List<BcmSyncDimension> bcmDimensions = new ArrayList<BcmSyncDimension>();
    private final List<BcmSyncMeasure> bcmMeasures = new ArrayList<BcmSyncMeasure>();

    public BcmSyncSchema(DynamicObject schemaDynamic, DataSyncModel syncModel, DataSource dataSource) {
        super(schemaDynamic, syncModel, dataSource);
        this.initRefInfo();
    }

    private void initRefInfo() {
        Map<Object, DynamicObject> collect = this.getDimensionMapEntry().stream().map(entry -> entry.getDynamicObject("dimension")).filter(dimension -> StringUtils.equals((CharSequence)"2", (CharSequence)dimension.getString("systemsource"))).collect(Collectors.toMap(DataEntityBase::getPkValue, d -> d));
        QFilter qfilter = new QFilter("dimension", "in", collect.keySet());
        try (DataSet dataSet = ORM.create().queryDataSet("BcmSyncDimension.new", "faf_cmdimmapping", "dimension,cmmodel,cmdimension,cmdimnumber,membermodel", qfilter.toArray());){
            for (Row next : dataSet) {
                Object pkvalue = next.get("dimension");
                DynamicObject dimension2 = collect.get(pkvalue);
                BcmSyncDimension syncDimension = new BcmSyncDimension(dimension2);
                syncDimension.setSourceNumber(next.getString("cmdimnumber"));
                syncDimension.setCmmodel(next.getLong("cmmodel"));
                syncDimension.setsDimensionId(next.getLong("cmdimension"));
                syncDimension.setsDimensionEntityname(next.getString("membermodel"));
                this.bcmDimensions.add(syncDimension);
            }
        }
        if (this.bcmDimensions.size() != collect.size()) {
            throw new KDBizException("import dimension setting not match size.");
        }
        for (DynamicObject entry2 : this.getMeasureMapEntry()) {
            DynamicObject measure = entry2.getDynamicObject("measure");
            if (!StringUtils.equals((CharSequence)"2", (CharSequence)measure.getString("systemsource"))) continue;
            this.bcmMeasures.add(new BcmSyncMeasure(measure));
        }
    }

    @Override
    protected Map<String, DataSyncDimension> getXSyncDimensionMap() {
        return this.bcmDimensions.stream().collect(Collectors.toMap(DataSync::getNumber, d -> d));
    }

    public String[] getImportDimionsions() {
        return (String[])this.bcmDimensions.stream().map(DataSyncDimension::getSourceNumber).toArray(String[]::new);
    }

    public Map<String, BcmSyncDimension> getImportDimionsionMap() {
        return this.bcmDimensions.stream().collect(Collectors.toMap(DataSyncDimension::getSourceNumber, o -> o));
    }

    public Map<Map<String, String>, String> getImportMeasureMap() {
        return this.bcmMeasures.stream().collect(Collectors.toMap(BcmSyncMeasure::getMembersMap, DataSync::getNumber));
    }

    @Override
    public List<List<Input>> getInputs(DataSyncParams params) {
        ArrayList<List<Input>> inputList = new ArrayList<List<Input>>();
        List<Object> entityList = this.mappingOrgParams(params.getOrgIdSet());
        List<Map<String, Object>> periodList = this.mappingPeriodParams(params.getPeriodIdSet());
        List<String> scenarioMembers = ((BcmDataSource)this.getDataSource()).getScenarioMembers();
        for (Object entity : entityList) {
            for (Map<String, Object> period : periodList) {
                for (String scenarioMember : scenarioMembers) {
                    ArrayList<BCMCustomizedInput> inputs = new ArrayList<BCMCustomizedInput>();
                    for (BcmSyncMeasure bcmMeasure : this.bcmMeasures) {
                        BcmApiRequest request = new BcmApiRequest();
                        request.setDataSourceNumber(((BcmDataSource)this.getDataSource()).getNumber());
                        request.setModelNum(((BcmDataSource)this.getDataSource()).getModelNum());
                        LinkedHashMap<String, String> fixDim = new LinkedHashMap<String, String>(4);
                        fixDim.put("Year", String.valueOf(period.get("Year")));
                        fixDim.put("Period", String.valueOf(period.get("Period")));
                        fixDim.put("Scenario", scenarioMember);
                        request.setFixDim(fixDim);
                        BcmApiFilter entityFilter = new BcmApiFilter("Entity", "10");
                        if (entity == null) continue;
                        entityFilter.getVal().add(String.valueOf(entity));
                        request.getFilters().add(entityFilter);
                        request.getFilters().addAll(this.getSchemaFilters(bcmMeasure));
                        if (!request.valid()) continue;
                        inputs.add(new BCMCustomizedInput(this.getSourceRowMeta(), request));
                    }
                    inputList.add(inputs);
                }
            }
        }
        return inputList;
    }

    private List<Object> mappingOrgParams(Set<Long> orgIdSet) {
        String fieldNumber = this.syncModel.getOrgNumber();
        List<Map<String, Object>> mapList = this.mappingParams(fieldNumber, orgIdSet);
        if (mapList != null) {
            return mapList.stream().map(stringMap -> stringMap.get("Entity")).distinct().collect(Collectors.toList());
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5fc5\u8981\u7ef4\u5ea6\u201c\u7ec4\u7ec7\u201d\u6ca1\u6709\u914d\u7f6e\u6620\u5c04\u5173\u7cfb", (String)"BcmSyncSchema_0", (String)"macc-faf-business", (Object[])new Object[0]));
    }

    private List<Map<String, Object>> mappingPeriodParams(Set<Long> periodIdSet) {
        String fieldNumber = this.syncModel.getPeriodNumber();
        List<Map<String, Object>> mapList = this.mappingParams(fieldNumber, periodIdSet);
        if (mapList != null) {
            return mapList;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5fc5\u8981\u7ef4\u5ea6\u201c\u671f\u95f4\u201d\u6ca1\u6709\u914d\u7f6e\u6620\u5c04\u5173\u7cfb", (String)"BcmSyncSchema_1", (String)"macc-faf-business", (Object[])new Object[0]));
    }

    private List<BcmApiFilter> getSchemaFilters(BcmSyncMeasure bcmMeasure) {
        Set<BcmApiFilter> measureFilters = bcmMeasure.getFilters();
        ArrayList<BcmApiFilter> list = new ArrayList<BcmApiFilter>(measureFilters);
        List<BcmApiFilter> datasourcefilters = ((BcmDataSource)this.getDataSource()).getFilters();
        for (BcmApiFilter datasourcefilter : datasourcefilters) {
            if (measureFilters.contains(datasourcefilter)) continue;
            list.add(datasourcefilter);
        }
        return list;
    }

    private RowMeta getSourceRowMeta() {
        if (this.sourceRowMeta == null) {
            this.generatorSourceRowMeta();
        }
        return this.sourceRowMeta;
    }

    private void generatorSourceRowMeta() {
        ArrayList<Field> list = new ArrayList<Field>(this.bcmDimensions.size() + this.bcmMeasures.size() + 1);
        for (BcmSyncDimension bcmDimsion : this.bcmDimensions) {
            list.add(new Field(bcmDimsion.getSourceNumber(), (DataType)DataType.StringType));
        }
        Set collect = this.bcmMeasures.stream().flatMap(bcmSyncMeasure -> bcmSyncMeasure.getBcmDimensionNumbers().stream()).collect(Collectors.toSet());
        for (String bcmDimsnion : collect) {
            list.add(new Field(bcmDimsnion, (DataType)DataType.StringType));
        }
        list.add(new Field("_faf_FMoney", (DataType)DataType.BigDecimalType));
        this.sourceRowMeta = new RowMeta(list.toArray(list.toArray(new Field[0])));
    }

    public boolean getSynctype() {
        return this.getDynamic().getBoolean("synctype");
    }
}

