/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Input;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.datasync.exec.data.DataSyncParams;
import kd.macc.faf.datasync.exec.data.DataSyncTransfer;
import kd.macc.faf.datasync.exec.func.BcmNumberToIdMapFunction;
import kd.macc.faf.datasync.exec.func.BcmRowToColGroupReduceFunction;
import kd.macc.faf.datasync.exec.func.SyncMapFunction;
import kd.macc.faf.datasync.exec.impl.BcmSyncDimension;
import kd.macc.faf.datasync.exec.impl.BcmSyncSchema;
import kd.macc.faf.datasync.exec.impl.SyncSchemaExec;

public class BcmSyncSchemaExec
extends SyncSchemaExec<BcmSyncSchema> {
    private static final Log logger = LogFactory.getLog(BcmSyncSchemaExec.class);

    public BcmSyncSchemaExec(BcmSyncSchema schema, DataSyncParams params) {
        super(schema, params);
    }

    @Override
    protected DataSetX exec(JobSession session, Input[] inputs) {
        DataSetX dataSetX = session.fromInput(inputs);
        Object[] importDimension = ((BcmSyncSchema)this.schema).getImportDimionsions();
        logger.info("[faf] bcm sync exec : import dimension {}", (Object)Arrays.toString(importDimension));
        Map<Map<String, String>, String> importMeasureMap = ((BcmSyncSchema)this.schema).getImportMeasureMap();
        logger.info("[faf] bcm sync exec : import measure map {}", importMeasureMap);
        DataSetX dsxSource = dataSetX.groupBy((String[])importDimension).reduceGroup((GroupReduceFunction)new BcmRowToColGroupReduceFunction(dataSetX.getRowMeta(), (String[])importDimension, importMeasureMap));
        Map<String, BcmSyncDimension> importDimionsionMap = ((BcmSyncSchema)this.schema).getImportDimionsionMap();
        DataSetX dsx2 = dsxSource.map((MapFunction)new BcmNumberToIdMapFunction(dsxSource.getRowMeta(), importDimionsionMap));
        List<DataSyncTransfer> dataTransfers = ((BcmSyncSchema)this.getSchema()).getDataTransfers();
        DataSetX dsxOut = dsx2.map((MapFunction)new SyncMapFunction(dsx2.getRowMeta(), dataTransfers));
        this.outDB(dsxOut);
        return (DataSetX)FAFUtils.cast((Object)dsxOut);
    }
}

