/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.datasource.dynamic.DataSource;
import kd.macc.faf.datasource.dynamic.EntityDataSource;
import kd.macc.faf.datasource.dynamic.FlexSourceField;
import kd.macc.faf.datasync.BusinessDynamicObjectFactory;
import kd.macc.faf.datasync.DataSyncBusinessHelper;
import kd.macc.faf.datasync.exec.data.DataSyncCondition;
import kd.macc.faf.datasync.exec.data.DataSyncDimension;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.datasync.exec.data.DataSyncParams;
import kd.macc.faf.datasync.exec.data.DataSyncSchema;
import kd.macc.faf.datasync.exec.data.DataSyncTransfer;
import kd.macc.faf.datasync.exec.data.EntityProppertyPath;
import kd.macc.faf.enums.DataSourceTypeEnum;
import kd.macc.faf.enums.FAFDimensionTypeEnum;
import kd.macc.faf.enums.SelectTypeEnum;
import kd.macc.faf.helper.BizVoucherHelper;
import kd.macc.faf.util.EntityUtils;

public class EntitySyncSchema
extends DataSyncSchema<EntityDataSource> {
    private static final Log logger = LogFactory.getLog(EntitySyncSchema.class);
    private static final long serialVersionUID = 9106478561375731167L;
    private String entryentityname;
    private String subentryentityname;
    private Set<String> dimFlexfieds;
    private int maxLevel = 0;
    private DataSyncCondition dataSyncCondition;
    private List<DataSyncTransfer> mTransfer;

    public EntitySyncSchema(DynamicObject schemaDynamic, DataSyncModel syncModel, DataSource dataSource) {
        super(schemaDynamic, syncModel, dataSource);
    }

    @Override
    public List<List<Input>> getInputs(DataSyncParams params) {
        List<QFilter> paramsQfilter = this.getParamsQFilters(params);
        paramsQfilter.addAll(((EntityDataSource)this.getDataSource()).getQFilters());
        OrmInput ormInput = new OrmInput("faf-sync-data-entity", ((EntityDataSource)this.getDataSource()).getEntityNumber(), this.getSelectFields(), paramsQfilter.toArray(new QFilter[0]));
        return Collections.singletonList(Collections.singletonList(ormInput));
    }

    @Override
    protected Map<String, DataSyncDimension> getXSyncDimensionMap() {
        LinkedHashMap<String, DataSyncDimension> map = new LinkedHashMap<String, DataSyncDimension>();
        DataSyncDimension id = new DataSyncDimension("sourcebillid", (DataType)DataType.LongType);
        id.setSourceNumber("id");
        map.put(id.getNumber(), id);
        return map;
    }

    public String getSelectFields() {
        LinkedHashSet<String> selectFields = new LinkedHashSet<String>();
        List<DataSyncTransfer> dataTransfers = this.getDataTransfers();
        for (DataSyncTransfer dataTransfer : dataTransfers) {
            String sourceFieldTypePropName;
            String transferType = dataTransfer.getTransferType();
            if (!StringUtils.isNotEmpty((CharSequence)transferType)) continue;
            if (transferType.equals("4")) {
                selectFields.addAll(dataTransfer.getSourceFields());
                continue;
            }
            String sourceFieldName = dataTransfer.getSourceFieldName();
            if (StringUtils.isNotEmpty((CharSequence)sourceFieldName)) {
                if (sourceFieldName.startsWith("dim_")) {
                    selectFields.add("entryentity.id as _entryid_dim");
                } else {
                    selectFields.add(sourceFieldName);
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)(sourceFieldTypePropName = dataTransfer.getSourceFieldTypePropName()))) continue;
            selectFields.add(sourceFieldTypePropName);
        }
        if (this.isConfigMultiEntry()) {
            selectFields.add(this.entryentityname + ".id as " + "_entryid_dim");
        }
        return String.join((CharSequence)",", selectFields);
    }

    public boolean isConfigMultiEntry() {
        List<DataSyncTransfer> multiEntryDataTransfers = this.getMultiEntryDataTransfers();
        return this.maxLevel == 2 && !multiEntryDataTransfers.isEmpty();
    }

    public Input getDimInput(DataSyncParams params) {
        Set<String> dimFlexFields = this.getDimFlexFields();
        if (!dimFlexFields.isEmpty()) {
            List<QFilter> paramsQfilter = this.getParamsQFilters(params);
            paramsQfilter.addAll(((EntityDataSource)this.getDataSource()).getQFilters());
            paramsQfilter.add(new QFilter("entryentity.subentryentity.flexfield", "in", dimFlexFields));
            return new OrmInput("faf-sync-data-entity", ((EntityDataSource)this.getDataSource()).getEntityNumber(), "entryentity.id as entryid, entryentity.subentryentity.flexfield as flexfield, entryentity.subentryentity.value as value", paramsQfilter.toArray(new QFilter[0]));
        }
        return null;
    }

    public Set<String> getDimFlexFields() {
        if (this.dimFlexfieds == null) {
            this.dimFlexfieds = new LinkedHashSet<String>();
            DataSourceTypeEnum type = ((EntityDataSource)this.getDataSource()).getType();
            if (DataSourceTypeEnum.BIZVOUCHER == type) {
                List<DataSyncTransfer> dataTransfers = this.getDataTransfers();
                for (DataSyncTransfer dataTransfer : dataTransfers) {
                    String sourceFieldName = dataTransfer.getSourceFieldName();
                    if (!StringUtils.isNotEmpty((CharSequence)sourceFieldName) || !sourceFieldName.startsWith("dim_")) continue;
                    this.dimFlexfieds.add(sourceFieldName.substring("dim_".length()));
                }
            }
        }
        return this.dimFlexfieds;
    }

    public List<DataSyncTransfer> getMultiEntryDataTransfers() {
        if (this.mTransfer == null) {
            this.genertorMultiEntryDataTransfers();
        }
        return this.mTransfer;
    }

    private void genertorMultiEntryDataTransfers() {
        this.mTransfer = new ArrayList<DataSyncTransfer>();
        List<DataSyncTransfer> dataTransfers = this.getDataTransfers();
        String entryentity = this.getEntryentityname();
        String subentryentity = this.getSubentryentityname();
        HashSet<Integer> set = new HashSet<Integer>();
        for (DataSyncTransfer dataTransfer : dataTransfers) {
            String sourceFieldName = dataTransfer.getSourceFieldName();
            if (StringUtils.isEmpty((CharSequence)sourceFieldName)) continue;
            if (StringUtils.isNotEmpty((CharSequence)subentryentity) && sourceFieldName.startsWith(entryentity + "." + subentryentity)) {
                dataTransfer.setEntryLevel(2);
                if (this.maxLevel < 2) {
                    this.maxLevel = 2;
                }
                set.add(2);
            } else if (StringUtils.isNotEmpty((CharSequence)entryentity) && sourceFieldName.startsWith(entryentity)) {
                dataTransfer.setEntryLevel(1);
                if (this.maxLevel < 1) {
                    this.maxLevel = 1;
                }
                set.add(1);
            } else {
                dataTransfer.setEntryLevel(0);
                set.add(0);
            }
            if (dataTransfer.getDataType() != DataType.BigDecimalType || dataTransfer.getEntryLevel() != 1 && dataTransfer.getEntryLevel() != 0) continue;
            this.mTransfer.add(dataTransfer);
        }
        for (DataSyncTransfer dataTransfer : this.mTransfer) {
            dataTransfer.setMaxEntryLevel(this.maxLevel);
        }
        if (set.size() <= 1) {
            this.mTransfer.clear();
        }
    }

    @Override
    public Map<String, String> matchFields(Object dimensionPkvalue) {
        Map<String, String> importDimension;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        EntityDataSource dataSource = (EntityDataSource)this.getDataSource();
        DataSourceTypeEnum sourceType = dataSource.getType();
        if (DataSourceTypeEnum.BIZVOUCHER == sourceType && dimensionPkvalue instanceof Long && (importDimension = this.syncModel.getMatchImportDimension(sourceType, (Long)dimensionPkvalue)).size() == 1) {
            return importDimension;
        }
        if ("matchImport".equals(this.getMatchModel())) {
            return map;
        }
        try {
            DataSyncDimension syncDimension;
            if (dimensionPkvalue != null) {
                syncDimension = BusinessDynamicObjectFactory.createDataSyncDimension(dimensionPkvalue);
                if (syncDimension.isImport()) {
                    return map;
                }
                syncDimension.setAutoMatch("autoMatch".equals(this.getMatchModel()));
            } else {
                syncDimension = new DataSyncDimension("Any", (DataType)DataType.AnyType);
            }
            MainEntityType entityType = dataSource.getMainEntityType();
            if (entityType == null) {
                return map;
            }
            this.setSelectedEntry(this.getAllSelectedFieldsNotSelf(dimensionPkvalue));
            this.matchAndPut(map, syncDimension, entityType.getAllFields());
            if (DataSourceTypeEnum.BIZVOUCHER == sourceType) {
                this.matchAndPutAIasstacttypeFields(map, syncDimension);
            } else if (DataSourceTypeEnum.VOUCHER == sourceType) {
                map.remove("endperiod");
            }
            if ("autoMatch".equals(this.getMatchModel()) && map.size() > 1) {
                Set entries = map.entrySet();
                Iterator iterator = entries.iterator();
                while (iterator.hasNext()) {
                    Map.Entry next = iterator.next();
                    if (Objects.equals(next.getKey(), syncDimension.getNumber())) {
                        return Collections.singletonMap(next.getKey(), next.getValue());
                    }
                    if (((String)next.getKey()).endsWith("." + syncDimension.getNumber())) continue;
                    iterator.remove();
                }
            }
        }
        catch (Exception ex) {
            logger.info("faf-sync-data: entitySyncSchema matchFields fail.", (Object)ex);
            throw new KDBizException(ex.getCause() != null ? ex.getCause().toString() : ex.toString());
        }
        return map;
    }

    @Override
    public List<ComboItem> matchMeasureFields() {
        MainEntityType entityType = ((EntityDataSource)this.getDataSource()).getMainEntityType();
        if (entityType == null) {
            return Collections.emptyList();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        DataSyncDimension syncDimension = new DataSyncDimension("Any", (DataType)DataType.BigDecimalType);
        this.setSelectedEntry(this.getAllSelectedFieldsNotSelf(-1L));
        this.matchAndPut(map, syncDimension, entityType.getAllFields());
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(map.size());
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            list.add(new ComboItem(new LocaleString((String)entry.getValue()), (String)entry.getKey()));
        }
        return list;
    }

    @Override
    public Object matchMeasureField(Object measurePkvalue) {
        return null;
    }

    private void matchAndPutAIasstacttypeFields(Map<String, String> map, DataSyncDimension syncDimension) {
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"faf_sync_query_ai_asstacttype", (String)"ai_asstacttype", (String)"flexfiled,name,datatype,valuesource,assistanttype", null, null);){
            for (Row row : dataSet) {
                String baseEntityId;
                if (syncDimension.matchAIasstacttype(row)) {
                    String number = row.getString("flexfiled");
                    String name = row.getString("name");
                    if (StringUtils.isNotEmpty((CharSequence)number)) {
                        map.put(BizVoucherHelper.addPrefix((String)number), BizVoucherHelper.addNamePrefix((String)name));
                    }
                }
                if ((baseEntityId = DataSyncBusinessHelper.getAIasstacttypeBaseEntityId(row)) == null) continue;
                EntityProppertyPath propertyPath = new EntityProppertyPath(BizVoucherHelper.addPrefix((String)row.getString("flexfiled")), BizVoucherHelper.addNamePrefix((String)row.getString("name")));
                this.expandedEntityId(map, syncDimension, baseEntityId, propertyPath, 1);
            }
        }
    }

    private void matchAndPut(Map<String, String> map, DataSyncDimension syncDimension, Map<String, IDataEntityProperty> allFields) {
        Collection<IDataEntityProperty> properties = allFields.values();
        for (IDataEntityProperty property : properties) {
            if (property instanceof FlexProp) {
                this.processFlexProp(map, syncDimension, (FlexProp)property);
                continue;
            }
            if (this.skipProperty(syncDimension, property) || !this.isMatchEntry(property)) continue;
            EntityProppertyPath propertyPath = EntityUtils.getEntityProppertyPath(property);
            if ((DataSourceTypeEnum.VOUCHER == ((EntityDataSource)this.getDataSource()).getType() || DataSourceTypeEnum.GLBALANCE == ((EntityDataSource)this.getDataSource()).getType() || DataSourceTypeEnum.BIZVOUCHER == ((EntityDataSource)this.getDataSource()).getType()) && ("comassist1".equals(property.getName()) || "comassist2".equals(property.getName()))) {
                this.matchAndPutComassist(map, syncDimension, property, propertyPath);
                continue;
            }
            if (syncDimension.match(property) || this.orMatch(syncDimension, property)) {
                map.put(propertyPath.getName(), propertyPath.getDisplayName());
            }
            if (!(property instanceof DynamicComplexProperty)) continue;
            this.expandedDynamicComplexProperty(map, syncDimension, (DynamicComplexProperty)property, propertyPath, 1);
        }
    }

    private boolean orMatch(DataSyncDimension syncDimension, IDataEntityProperty property) {
        if (syncDimension.isAutoMatch()) {
            return false;
        }
        if (DataSourceTypeEnum.TEMPPORARY == ((EntityDataSource)this.getDataSource()).getType()) {
            return Objects.equals(this.getSyncModel().getPeriodField().getPkValue(), syncDimension.getPkValue()) && "bd_period".equals(syncDimension.getSourceEntityname()) && property instanceof DateTimeProp;
        }
        return false;
    }

    private boolean skipProperty(DataSyncDimension syncDimension, IDataEntityProperty property) {
        if (property instanceof ItemClassProp && this.getSyncModel().isNecessity(syncDimension.getPkValue())) {
            return true;
        }
        return !syncDimension.isUsable(property);
    }

    private void processFlexProp(Map<String, String> map, DataSyncDimension syncDimension, FlexProp property) {
        if (DateType.BigDecimalType == syncDimension.getDataType()) {
            return;
        }
        if (!syncDimension.isUsable((IDataEntityProperty)property)) {
            return;
        }
        if (this.getSyncModel().isNecessity(syncDimension.getPkValue())) {
            return;
        }
        if (DataSourceTypeEnum.INV_PERIODBALANCE == ((EntityDataSource)this.getDataSource()).getType()) {
            return;
        }
        if (!this.isMatchEntry((IDataEntityProperty)property)) {
            return;
        }
        EntityProppertyPath propertyPath = EntityUtils.getEntityProppertyPath((IDataEntityProperty)property);
        Map<String, FlexSourceField> flexPropertyMap = ((EntityDataSource)this.getDataSource()).getFlexPropertyMap(property);
        Collection<FlexSourceField> values = flexPropertyMap.values();
        for (FlexSourceField flexField : values) {
            EntityProppertyPath nextPath = propertyPath.nextPath("_" + flexField.getFlexfield(), "_" + flexField.getName());
            if (syncDimension.match(flexField)) {
                map.put(nextPath.getName(), nextPath.getDisplayName());
            }
            if (!Objects.equals(flexField.getValuetype(), "1") && !Objects.equals(flexField.getValuetype(), "2")) continue;
            this.expandedEntityId(map, syncDimension, flexField.getValuesource(), nextPath, 1);
        }
    }

    private void matchAndPutComassist(Map<String, String> map, DataSyncDimension syncDimension, IDataEntityProperty property, EntityProppertyPath propertyPath) {
        if (DateType.BigDecimalType == syncDimension.getDataType()) {
            return;
        }
        if (this.getSyncModel().isNecessity(syncDimension.getPkValue())) {
            return;
        }
        DynamicObject accountField = this.syncModel.getAccountField();
        Map<String, DynamicObject> comassist = ((EntityDataSource)this.getDataSource()).getComassist(accountField);
        DynamicObject dynamicObject = comassist.get(property.getName());
        if (dynamicObject != null) {
            boolean match;
            String baseEntityId;
            String endfix;
            if (FAFDimensionTypeEnum.DATABASE.eq((Object)dynamicObject.getString("valuesourcetype"))) {
                endfix = dynamicObject.getString("valuesource.name");
                baseEntityId = dynamicObject.getString("valuesource.number");
                match = syncDimension.matchComassist(baseEntityId, null);
            } else if (FAFDimensionTypeEnum.ASSISTANTDATA.eq((Object)dynamicObject.getString("valuesourcetype"))) {
                endfix = dynamicObject.getString("assistantvaluesource.name");
                baseEntityId = "bos_assistantdata_detail";
                match = syncDimension.matchComassist(baseEntityId, dynamicObject.getLong("assistantvaluesource.id"));
            } else {
                return;
            }
            EntityProppertyPath nextPath = propertyPath.nextPath("", "." + endfix);
            if (match) {
                map.put(nextPath.getName(), nextPath.getDisplayName());
            }
            if (endfix != null) {
                this.expandedEntityId(map, syncDimension, baseEntityId, nextPath, 1);
            }
        }
    }

    private void expandedDynamicComplexProperty(Map<String, String> map, DataSyncDimension syncDimension, DynamicComplexProperty prop, EntityProppertyPath propertyPath, int level) {
        if (prop instanceof ItemClassProp) {
            return;
        }
        if (prop instanceof BasedataProp) {
            this.expandedEntityId(map, syncDimension, ((BasedataProp)prop).getBaseEntityId(), propertyPath, level);
        } else if (prop instanceof RefBillProp) {
            this.expandedEntityId(map, syncDimension, ((RefBillProp)prop).getBillEntityId(), propertyPath, level);
        }
    }

    private void expandedEntityId(Map<String, String> map, DataSyncDimension syncDimension, String baseEntityId, EntityProppertyPath propertyPath, int level) {
        Collection properties;
        if (StringUtils.isEmpty((CharSequence)baseEntityId)) {
            return;
        }
        if (DateType.BigDecimalType == syncDimension.getDataType()) {
            return;
        }
        if ("autoMatch".equals(this.getMatchModel())) {
            return;
        }
        if (this.syncModel.isNecessity(syncDimension.getPkValue())) {
            return;
        }
        try {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
            properties = dataEntityType.getFields().values();
        }
        catch (Exception ex) {
            logger.error("[faf]matchbasedata:" + propertyPath.toString(), (Throwable)ex);
            return;
        }
        for (IDataEntityProperty property : properties) {
            if (!syncDimension.isUsable(property)) continue;
            String separator = level == 1 ? "-" : ".";
            EntityProppertyPath nextPath = propertyPath.nextPath(separator, property);
            if (syncDimension.match(property) && !nextPath.isExclude(property)) {
                map.put(nextPath.getName(), nextPath.getDisplayName());
            }
            if (level >= 2 || !(property instanceof DynamicComplexProperty)) continue;
            this.expandedDynamicComplexProperty(map, syncDimension, (DynamicComplexProperty)property, nextPath, level + 1);
        }
    }

    private boolean isMatchEntry(IDataEntityProperty property) {
        IDataEntityType parent = property.getParent();
        if (parent instanceof SubEntryType) {
            if (DataSourceTypeEnum.TEMPPORARY != ((EntityDataSource)this.getDataSource()).getType()) {
                return false;
            }
            if (parent.isDbIgnore()) {
                return false;
            }
            EntryType entryType = (EntryType)parent.getParent();
            if (this.entryentityname != null && !Objects.equals(this.entryentityname, entryType.getName())) {
                return false;
            }
            return this.subentryentityname == null || Objects.equals(this.subentryentityname, parent.getName());
        }
        if (parent instanceof EntryType) {
            if (parent.isDbIgnore()) {
                return false;
            }
            return this.entryentityname == null || Objects.equals(this.entryentityname, parent.getName());
        }
        return true;
    }

    public void setSelectedEntry(Set<String> allSelectedFields) {
        MainEntityType mainEntityType = ((EntityDataSource)this.getDataSource()).getMainEntityType();
        for (String field : allSelectedFields) {
            String[] split;
            DynamicProperty prop;
            if (!field.contains(".") || !((prop = mainEntityType.getProperty((split = field.split("\\."))[0])) instanceof EntryProp) || split.length <= 1) continue;
            this.entryentityname = prop.getName();
            DynamicProperty subProp = ((EntryProp)prop).getDynamicCollectionItemPropertyType().getProperty(split[1]);
            if (!(subProp instanceof SubEntryProp) || split.length <= 2) continue;
            this.subentryentityname = subProp.getName();
            return;
        }
    }

    private Set<String> getAllSelectedFieldsNotSelf(Object pkvalue) {
        if (pkvalue == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> selectedPropNames = new LinkedHashSet<String>();
        DynamicObjectCollection dimensionMapEntry = this.getDimensionMapEntry();
        for (DynamicObject entry : dimensionMapEntry) {
            String dimensionfield;
            if (Objects.equals(pkvalue, entry.get("dimension_id")) || !StringUtils.isNotEmpty((CharSequence)(dimensionfield = entry.getString("dimensionfield")))) continue;
            selectedPropNames.add(dimensionfield);
        }
        DynamicObjectCollection measureMapEntry = this.getMeasureMapEntry();
        for (DynamicObject entry : measureMapEntry) {
            String measurefield = entry.getString("measurefield");
            if (!StringUtils.isNotEmpty((CharSequence)measurefield)) continue;
            selectedPropNames.add(measurefield);
        }
        return selectedPropNames;
    }

    public String getEntryentityname() {
        if (this.entryentityname == null) {
            this.setSelectedEntry(this.getAllSelectedFieldsNotSelf(-1L));
            if (this.entryentityname == null) {
                this.entryentityname = "";
            }
        }
        return this.entryentityname;
    }

    public String getSubentryentityname() {
        if (this.subentryentityname == null) {
            this.setSelectedEntry(this.getAllSelectedFieldsNotSelf(-1L));
            if (this.subentryentityname == null) {
                this.subentryentityname = "";
            }
        }
        return this.subentryentityname;
    }

    @Override
    public List<ComboItem> getSelectTypeComboItems() {
        DataSourceTypeEnum type = ((EntityDataSource)this.getDataSource()).getType();
        if (type == DataSourceTypeEnum.BIZVOUCHER) {
            return Arrays.asList(SelectTypeEnum.CONDITION.toComboItem(), SelectTypeEnum.CONSTANT.toComboItem(), SelectTypeEnum.MEASUREFIELD.toComboItem(), SelectTypeEnum.DIMMEASUREFIELD.toComboItem());
        }
        return super.getSelectTypeComboItems();
    }

    public DataSyncCondition getDataSyncCondition() {
        if (this.dataSyncCondition == null) {
            this.generatorSetValCondition();
        }
        return this.dataSyncCondition;
    }

    private void generatorSetValCondition() {
        String entitynumber = this.getSyncModel().getEntitynumber();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entitynumber);
        this.dataSyncCondition = new DataSyncCondition(dataEntityType);
        DynamicObjectCollection dEntry = this.getDimensionMapEntry();
        for (DynamicObject entry : dEntry) {
            String dimConditionJson = entry.getString("dimconditionval_tag");
            if (!StringUtils.isNotEmpty((CharSequence)dimConditionJson)) continue;
            String dimNumber = entry.getString("dimension.number");
            this.dataSyncCondition.putConditionJson(dimNumber, dimConditionJson);
        }
    }
}

