/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.JoinFunction;
import kd.bos.algox.MapFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.algox.FAFJoinLinkFunction;
import kd.macc.faf.algox.FAFJoinLinkInfo;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.datasource.dynamic.FlexSourceField;
import kd.macc.faf.datasync.exec.data.DataSyncCondition;
import kd.macc.faf.datasync.exec.data.DataSyncDimension;
import kd.macc.faf.datasync.exec.data.DataSyncParams;
import kd.macc.faf.datasync.exec.data.DataSyncTransfer;
import kd.macc.faf.datasync.exec.func.DimGroupReduceFunction;
import kd.macc.faf.datasync.exec.func.MultiEntryClearMapFunction;
import kd.macc.faf.datasync.exec.func.SyncConditionMapFunction;
import kd.macc.faf.datasync.exec.func.SyncMapFunction;
import kd.macc.faf.datasync.exec.impl.EntitySyncSchema;
import kd.macc.faf.datasync.exec.impl.SyncSchemaExec;

public class EntitySyncSchemaExec
extends SyncSchemaExec<EntitySyncSchema> {
    private static final Log logger = LogFactory.getLog(EntitySyncSchemaExec.class);

    public EntitySyncSchemaExec(EntitySyncSchema schema, DataSyncParams params) {
        super(schema, params);
        this.inputs = schema.getInputs(params);
    }

    @Override
    protected DataSetX exec(JobSession session, Input[] inputs) {
        logger.info("faf-sync-data: entity schema sync exec ");
        DataSetX dataSetX = session.fromInput(inputs);
        List<DataSyncTransfer> dataTransfers = ((EntitySyncSchema)this.schema).getDataTransfers();
        Map<String, DataSyncDimension> flexMap = ((EntitySyncSchema)this.schema).getFlexDataSyncDimensionMap();
        for (DataSyncDimension syncDimension : flexMap.values()) {
            FlexSourceField flexField = syncDimension.getFlexField();
            OrmInput ormInput = flexField.getOrmInput();
            DataSetX dsxFlex = session.fromInput((Input)ormInput);
            JoinDataSetX joinDsX = dataSetX.leftJoin(dsxFlex).on(syncDimension.getSourceNumber(), "hg");
            FAFJoinLinkInfo joinInfo = syncDimension.getFlexFieldJoinInfo();
            dataSetX = joinDsX.withFunc((JoinFunction)new FAFJoinLinkFunction(dataSetX.getRowMeta(), joinInfo));
        }
        Input dimInput = ((EntitySyncSchema)this.schema).getDimInput(this.params);
        if (dimInput != null) {
            DataSetX dsxDim = session.fromInput(dimInput);
            Set<String> dimFlexFields = ((EntitySyncSchema)this.schema).getDimFlexFields();
            DataSetX entityid_dim = dsxDim.groupBy(new String[]{"entryid"}).reduceGroup((GroupReduceFunction)new DimGroupReduceFunction(dimFlexFields));
            FAFJoinLinkInfo joinDimInfo = new FAFJoinLinkInfo();
            joinDimInfo.setLeftField("_entryid_dim");
            joinDimInfo.setRightField("entryid");
            for (String dimFlexField : dimFlexFields) {
                joinDimInfo.addLinkField(dimFlexField, (DataType)DataType.StringType);
            }
            dataSetX = dataSetX.leftJoin(entityid_dim).on("_entryid_dim", "entryid").withFunc((JoinFunction)new FAFJoinLinkFunction(dataSetX.getRowMeta(), joinDimInfo));
        }
        SyncMapFunction syncMapFunction = new SyncMapFunction(dataSetX.getRowMeta(), dataTransfers);
        List<DataSyncTransfer> multiEntryDataTransfers = ((EntitySyncSchema)this.schema).getMultiEntryDataTransfers();
        if (((EntitySyncSchema)this.schema).isConfigMultiEntry()) {
            dataSetX = dataSetX.groupBy(new String[]{"id"}).reduceGroup((GroupReduceFunction)new MultiEntryClearMapFunction(dataSetX.getRowMeta(), multiEntryDataTransfers));
        }
        DataSetX dsxOut = dataSetX.map((MapFunction)syncMapFunction);
        DataSyncCondition dataSyncCondition = ((EntitySyncSchema)this.schema).getDataSyncCondition();
        if (dataSyncCondition != null && dataSyncCondition.isConfig()) {
            dsxOut = dsxOut.map((MapFunction)new SyncConditionMapFunction(dsxOut.getRowMeta(), dataSyncCondition));
        }
        this.outDB(dsxOut);
        return (DataSetX)FAFUtils.cast((Object)dsxOut);
    }
}

