/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.macc.faf.datasync.BusinessDynamicObjectFactory;
import kd.macc.faf.datasync.FAFDataSyncDTO;
import kd.macc.faf.datasync.exec.Exec;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.datasync.exec.data.DataSyncParams;
import kd.macc.faf.datasync.task.FAFOlapDataProcessTask;
import kd.macc.faf.datasync.task.FAFStandardEntityProcessTask;
import kd.macc.faf.dto.DataExtractingDTO;
import kd.macc.faf.dto.OlapDataExtractingDTO;
import kd.macc.faf.enums.DataSourceTypeEnum;
import kd.macc.faf.helper.FAFSyncDataSchemeHelper;
import kd.macc.faf.olap.KdOlapServerHelper;
import kd.macc.faf.olap.OlapMultipleSplitSQLBuilder;
import kd.macc.faf.olap.OlapSQLBuilder;

public class GenericSchemaExec
implements Exec<DynamicObject, List<JobSession>> {
    private final DataSyncModel syncModel;
    private final DataSyncParams params;

    public GenericSchemaExec(DataSyncModel syncModel, DataSyncParams params) {
        this.syncModel = syncModel;
        this.params = params;
    }

    @Override
    public List<JobSession> exec(DynamicObject schema) {
        OlapDataExtractingDTO extractingDTO;
        FAFDataSyncDTO dto = new FAFDataSyncDTO(this.syncModel.getDynamic(), schema, this.params.getOrgIdSet().toArray(new Long[0]), this.params.getPeriodIdSet().toArray(new Long[0]), this.params.getTimeType(), this.params.getStartDate(), this.params.getEndDate());
        DataSourceTypeEnum dataSourceType = dto.getEntityType();
        boolean syncType = dto.getSyncType();
        if (DataSourceTypeEnum.TEMPPORARY == dataSourceType || DataSourceTypeEnum.VOUCHER == dataSourceType || DataSourceTypeEnum.BIZVOUCHER == dataSourceType) {
            Object dataSyncSchema = BusinessDynamicObjectFactory.createDataSyncSchema(schema);
            return Collections.singletonList(FAFStandardEntityProcessTask.createSession(dto.getEntityType(), dto, dataSyncSchema));
        }
        if ((DataSourceTypeEnum.BCM == dataSourceType && !syncType || DataSourceTypeEnum.EPM == dataSourceType) && (extractingDTO = FAFSyncDataSchemeHelper.buildOlapDataExtractingDTO((Long)schema.getLong("id"), dto.getOrgIdSet(), dto.getPeriodIdSet())) != null) {
            extractingDTO.buildExtractingValues();
            if (!KdOlapServerHelper.checkExtractingOlapData((OlapDataExtractingDTO)extractingDTO, (DataExtractingDTO)((DataExtractingDTO)this.params.getExts().get("DataExtractingDTO")))) {
                return null;
            }
            FAFOlapDataProcessTask olapDataProcessTask = FAFOlapDataProcessTask.getInstance();
            OlapMultipleSplitSQLBuilder multipleSplitSQLBuilder = FAFOlapDataProcessTask.getInstance().validateDimMembersAndGetSQlBuilder(extractingDTO);
            Map<String, Map<String, Long>> entityNumberTransIdMap = olapDataProcessTask.getEntityNumberTransIdMap(extractingDTO, multipleSplitSQLBuilder);
            ArrayList<JobSession> sessions = new ArrayList<JobSession>(8);
            while (multipleSplitSQLBuilder.hasNext()) {
                OlapSQLBuilder sqlBuilder = multipleSplitSQLBuilder.next();
                sessions.add(FAFOlapDataProcessTask.getInstance().execute(extractingDTO, (Long)this.syncModel.getPkValue(), sqlBuilder, entityNumberTransIdMap));
            }
            return sessions;
        }
        return null;
    }
}

