/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.impl;

import java.util.List;
import java.util.Map;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.JoinFunction;
import kd.bos.algox.MapFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.algox.FAFJoinLinkFunction;
import kd.macc.faf.algox.FAFJoinLinkInfo;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.datasource.dynamic.FlexSourceField;
import kd.macc.faf.datasync.FAFDataSyncDTO;
import kd.macc.faf.datasync.exec.data.DataSyncCondition;
import kd.macc.faf.datasync.exec.data.DataSyncDimension;
import kd.macc.faf.datasync.exec.data.DataSyncParams;
import kd.macc.faf.datasync.exec.data.DataSyncTransfer;
import kd.macc.faf.datasync.exec.func.SyncConditionMapFunction;
import kd.macc.faf.datasync.exec.func.SyncMapFunction;
import kd.macc.faf.datasync.exec.impl.GlBalanceSyncSchema;
import kd.macc.faf.datasync.exec.impl.SyncSchemaExec;

public class GlBalanceSchemaExec
extends SyncSchemaExec<GlBalanceSyncSchema> {
    private static final Log logger = LogFactory.getLog(GlBalanceSchemaExec.class);

    public GlBalanceSchemaExec(GlBalanceSyncSchema schema, DataSyncParams params) {
        super(schema, params);
    }

    @Override
    protected DataSetX exec(JobSession session, Input[] inputs) {
        DataSetX dataSetX = session.fromInput(inputs);
        logger.info("[faf] inv sync exec ");
        FAFDataSyncDTO dto = ((GlBalanceSyncSchema)this.schema).getSyncDTO();
        List<DataSyncTransfer> dataTransfers = ((GlBalanceSyncSchema)this.schema).getDataTransfers();
        Map<String, DataSyncDimension> flexMap = ((GlBalanceSyncSchema)this.schema).getFlexDataSyncDimensionMap();
        for (DataSyncDimension syncDimension : flexMap.values()) {
            FlexSourceField flexField = syncDimension.getFlexField();
            OrmInput ormInput = flexField.getOrmInput();
            DataSetX dsxFlex = session.fromInput((Input)ormInput);
            JoinDataSetX joinDsX = dataSetX.leftJoin(dsxFlex).on(syncDimension.getSourceNumber(), "hg");
            FAFJoinLinkInfo joinInfo = syncDimension.getFlexFieldJoinInfo();
            dataSetX = joinDsX.withFunc((JoinFunction)new FAFJoinLinkFunction(dataSetX.getRowMeta(), joinInfo));
        }
        if (((GlBalanceSyncSchema)this.schema).getAccountSelectField().size() > 1) {
            OrmInput accountViewInput = new OrmInput("kd.fi.pa.datasync.GlBalanceSchemaExec.accountView", "bd_accountview", String.join((CharSequence)",", ((GlBalanceSyncSchema)this.schema).getAccountSelectField()), null);
            DataSetX accountViewDsx = session.fromInput((Input)accountViewInput);
            dataSetX = dataSetX.leftJoin(accountViewDsx).on("account", "id").removeFields(new String[]{"id"});
        }
        DataSetX dsxOut = dataSetX.map((MapFunction)new SyncMapFunction(dataSetX.getRowMeta(), dataTransfers));
        DataSyncCondition dataSyncCondition = ((GlBalanceSyncSchema)this.schema).getDataSyncCondition();
        if (dataSyncCondition != null && dataSyncCondition.isConfig()) {
            dsxOut = dsxOut.map((MapFunction)new SyncConditionMapFunction(dsxOut.getRowMeta(), dataSyncCondition));
        }
        this.outDB(dsxOut);
        return (DataSetX)FAFUtils.cast((Object)dsxOut);
    }
}

