/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.macc.faf.datasource.dynamic.DataSource;
import kd.macc.faf.datasource.dynamic.EntityDataSource;
import kd.macc.faf.datasync.FAFDataSyncDTO;
import kd.macc.faf.datasync.FAFGlBalanceParamIterator;
import kd.macc.faf.datasync.exec.data.DataSyncDimension;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.datasync.exec.data.DataSyncParams;
import kd.macc.faf.datasync.exec.impl.EntitySyncSchema;
import kd.macc.faf.datasync.exec.input.glbalance.GlBalanceCustomizedInput;
import kd.macc.faf.datasync.param.BalanceQueryParam;
import kd.macc.faf.enums.FAFDimensionTypeEnum;
import kd.macc.faf.enums.SelectTypeEnum;
import kd.macc.faf.util.CalculateCondition;

public class GlBalanceSyncSchema
extends EntitySyncSchema {
    private static final Log logger = LogFactory.getLog(GlBalanceSyncSchema.class);
    private static final long serialVersionUID = 3219046698895757409L;
    private final Set<String> accountSelectField = new HashSet<String>(10);
    protected Map<String, CalculateCondition> conditionMap = new HashMap<String, CalculateCondition>(10);
    private FAFDataSyncDTO syncDTO;

    public GlBalanceSyncSchema(DynamicObject schemaDynamic, DataSyncModel syncModel, DataSource dataSource) {
        super(schemaDynamic, syncModel, dataSource);
    }

    public void initAccountSelectField() {
        try {
            for (DynamicObject measure : this.getMeasureMapEntry()) {
                String conditionString = measure.getString("condition_tag");
                if (!SelectTypeEnum.CONDITION.getCode().equals(measure.getString("selecttype")) || !StringUtils.isNotEmpty((CharSequence)conditionString)) continue;
                CalculateCondition condition = new CalculateCondition("gl_balance", conditionString);
                this.conditionMap.put(measure.getString("measure.number"), condition);
                Set propertys = condition.parseProperty();
                for (String property : propertys) {
                    if (!property.contains("account.")) continue;
                    this.accountSelectField.add(property.substring("account.".length()) + " as " + property);
                }
            }
            if (!this.accountSelectField.isEmpty()) {
                this.accountSelectField.add("id");
            }
        }
        catch (Exception ex) {
            logger.info("faf-sync-data: GlBalanceSyncSchema", (Object)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    @Override
    public List<List<Input>> getInputs(DataSyncParams params) {
        if (this.syncDTO == null) {
            this.syncDTO = new FAFDataSyncDTO(this.syncModel.getDynamic(), this.getDynamic(), params.getOrgIdSet().toArray(new Long[0]), params.getPeriodIdSet().toArray(new Long[0]), params.getTimeType(), params.getStartDate(), params.getEndDate());
        }
        FAFGlBalanceParamIterator iterator = new FAFGlBalanceParamIterator(this.syncDTO.getOrgIdSet(), this.syncDTO.getPeriodIdSet(), this.syncModel.getAccountField().getLong("group_id"), ((EntityDataSource)this.getDataSource()).getBookTypeId(), this.syncDTO);
        ArrayList<GlBalanceCustomizedInput> inputs = new ArrayList<GlBalanceCustomizedInput>(8);
        while (iterator.hasNext()) {
            BalanceQueryParam request = iterator.next();
            inputs.add(new GlBalanceCustomizedInput(this.getSourceRowMeta(iterator.getSelectorSet()), request));
        }
        return Collections.singletonList(inputs);
    }

    public boolean validExecute() {
        DynamicObject accountField = this.syncModel.getAccountField();
        DynamicObject periodField = this.syncModel.getPeriodField();
        String entityNumber = accountField.getString("dimensionsource.number");
        if (!"bd_accountview".equals(entityNumber)) {
            logger.info("MACC-BALANCE: accountType noMatch" + entityNumber);
            return false;
        }
        String periodEntityNumber = periodField.getString("dimensionsource.number");
        if (!"bd_period".equals(periodEntityNumber)) {
            logger.info("MACC-BALANCE: periodType noMatch" + entityNumber);
            return false;
        }
        return true;
    }

    private RowMeta getSourceRowMeta(Set<String> selectorSets) {
        if (this.sourceRowMeta == null) {
            this.generatorSourceRowMeta(selectorSets);
        }
        return this.sourceRowMeta;
    }

    private void generatorSourceRowMeta(Set<String> selectorSets) {
        this.sourceRowMeta = ORM.create().createRowMeta("gl_balance", String.join((CharSequence)",", selectorSets) + ",period");
    }

    public FAFDataSyncDTO getSyncDTO() {
        return this.syncDTO;
    }

    public Set<String> getAccountSelectField() {
        if (this.accountSelectField.isEmpty()) {
            this.initAccountSelectField();
        }
        return this.accountSelectField;
    }

    @Override
    protected String getSourceRefFieldEntityname(DataSyncDimension syncDimension) {
        IDataEntityProperty property = syncDimension.getSourceProperty();
        if (property != null && ("comassist1".equals(property.getName()) || "comassist2".equals(property.getName()))) {
            DynamicObject accountField = this.syncModel.getAccountField();
            Map<String, DynamicObject> comassist = ((EntityDataSource)this.getDataSource()).getComassist(accountField);
            DynamicObject dynamicObject = comassist.get(property.getName());
            if (dynamicObject != null) {
                if (FAFDimensionTypeEnum.DATABASE.eq((Object)dynamicObject.getString("valuesourcetype"))) {
                    return dynamicObject.getString("valuesource.number");
                }
                if (FAFDimensionTypeEnum.ASSISTANTDATA.eq((Object)dynamicObject.getString("valuesourcetype"))) {
                    return "bos_assistantdata_detail";
                }
            }
            return "";
        }
        return super.getSourceRefFieldEntityname(syncDimension);
    }

    @Override
    protected Map<String, DataSyncDimension> getXSyncDimensionMap() {
        return Collections.emptyMap();
    }
}

