/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.macc.faf.datasource.dynamic.DataSource;
import kd.macc.faf.datasource.dynamic.EntityDataSource;
import kd.macc.faf.datasync.exec.data.DataSyncDimension;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.datasync.exec.data.DataSyncParams;
import kd.macc.faf.datasync.exec.data.DataSyncTransfer;
import kd.macc.faf.datasync.exec.impl.EntitySyncSchema;
import kd.macc.faf.enums.SelectTypeEnum;

public class InvSyncSchema
extends EntitySyncSchema {
    private static final Log logger = LogFactory.getLog(InvSyncSchema.class);
    private static final long serialVersionUID = 9106478561375731167L;

    public InvSyncSchema(DynamicObject schemaDynamic, DataSyncModel syncModel, DataSource dataSource) {
        super(schemaDynamic, syncModel, dataSource);
    }

    @Override
    protected Map<String, DataSyncDimension> getXSyncDimensionMap() {
        LinkedHashMap<String, DataSyncDimension> map = new LinkedHashMap<String, DataSyncDimension>();
        DataSyncDimension id = new DataSyncDimension("sourcebillid", (DataType)DataType.LongType);
        id.setSourceNumber("id");
        map.put(id.getNumber(), id);
        DataSyncDimension syncDimension = new DataSyncDimension(this.syncModel.getPeriodField());
        syncDimension.setSourceNumber("period");
        map.put(syncDimension.getNumber(), syncDimension);
        return map;
    }

    @Override
    public String getSelectFields() {
        LinkedHashSet<String> selectFields = new LinkedHashSet<String>();
        List<DataSyncTransfer> dataTransfers = this.getDataTransfers();
        block10: for (DataSyncTransfer dataTransfer : dataTransfers) {
            String sourceFieldName = dataTransfer.getSourceFieldName();
            if (!StringUtils.isNotEmpty((CharSequence)sourceFieldName)) continue;
            switch (sourceFieldName) {
                case "qty": {
                    selectFields.add("qty_bal");
                    continue block10;
                }
                case "baseqty": {
                    selectFields.add("baseqty_bal");
                    continue block10;
                }
                case "qty2nd": {
                    selectFields.add("qty2nd_bal");
                    continue block10;
                }
            }
            selectFields.add(sourceFieldName);
        }
        selectFields.add("endperiod");
        return String.join((CharSequence)",", selectFields);
    }

    @Override
    public List<List<Input>> getInputs(DataSyncParams params) {
        Integer periodInteger = params.getPeriodInteger();
        if (periodInteger == null) {
            logger.info("[faf] inv sync empty");
            return Collections.emptyList();
        }
        List<QFilter> qFilters = ((EntityDataSource)this.getDataSource()).getQFilters();
        qFilters.add(new QFilter(this.getSourceOrgNumber(), "in", params.getOrgIdSet()));
        qFilters.add(new QFilter("period", "=", (Object)params.getPeriodInteger()).or(new QFilter("period", "<", (Object)params.getPeriodInteger()).and("endperiod", ">=", (Object)params.getPeriodInteger())));
        OrmInput ormInput = new OrmInput("faf-sync-data-inv-input", ((EntityDataSource)this.getDataSource()).getEntityNumber(), this.getSelectFields(), qFilters.toArray(new QFilter[0]));
        return Collections.singletonList(Collections.singletonList(ormInput));
    }

    @Override
    public List<ComboItem> getSelectTypeComboItems() {
        return Collections.singletonList(SelectTypeEnum.MEASUREFIELD.toComboItem());
    }

    @Override
    public List<ComboItem> matchMeasureFields() {
        List<ComboItem> comboItems = super.matchMeasureFields();
        comboItems.remove(new ComboItem(null, "period"));
        comboItems.remove(new ComboItem(null, "endperiod"));
        return comboItems;
    }
}

