/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.impl;

import java.util.List;
import java.util.Set;
import kd.bos.algo.Input;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.datasync.exec.data.DataSyncCondition;
import kd.macc.faf.datasync.exec.data.DataSyncParams;
import kd.macc.faf.datasync.exec.data.DataSyncTransfer;
import kd.macc.faf.datasync.exec.func.InvMeasureValueMapFunction;
import kd.macc.faf.datasync.exec.func.SyncConditionMapFunction;
import kd.macc.faf.datasync.exec.func.SyncMapFunction;
import kd.macc.faf.datasync.exec.impl.InvSyncSchema;
import kd.macc.faf.datasync.exec.impl.SyncSchemaExec;

public class InvSyncSchemaExec
extends SyncSchemaExec<InvSyncSchema> {
    private static final Log logger = LogFactory.getLog(InvSyncSchemaExec.class);

    public InvSyncSchemaExec(InvSyncSchema schema, DataSyncParams params) {
        super(schema, params);
    }

    @Override
    protected DataSetX exec(JobSession session, Input[] inputs) {
        DataSetX dataSetX = session.fromInput(inputs);
        logger.info("[faf] inv sync exec ");
        Set<String> sourceMeasures = ((InvSyncSchema)this.schema).getSourceMeasures();
        DataSetX dsX = dataSetX.map((MapFunction)new InvMeasureValueMapFunction(dataSetX.getRowMeta(), sourceMeasures, this.params.getPeriodId(), this.params.getPeriodInteger()));
        List<DataSyncTransfer> dataTransfers = ((InvSyncSchema)this.schema).getDataTransfers();
        DataSetX dsxOut = dsX.filter("id > 0").map((MapFunction)new SyncMapFunction(dsX.getRowMeta(), dataTransfers));
        DataSyncCondition dataSyncCondition = ((InvSyncSchema)this.schema).getDataSyncCondition();
        if (dataSyncCondition.isConfig()) {
            dsxOut = dsxOut.map((MapFunction)new SyncConditionMapFunction(dsxOut.getRowMeta(), dataSyncCondition));
        }
        this.outDB(dsxOut);
        return (DataSetX)FAFUtils.cast((Object)dsxOut);
    }
}

