/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.impl;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.macc.faf.datasource.dynamic.DataSource;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.datasync.exec.data.DataSyncSchema;
import kd.macc.faf.enums.DataSourceTypeEnum;

public abstract class NoEntitySyncSchema<T extends DataSource>
extends DataSyncSchema<T> {
    private static final long serialVersionUID = -4041960663665287247L;

    public NoEntitySyncSchema(DynamicObject schemaDynamic, DataSyncModel syncModel, DataSource dataSource) {
        super(schemaDynamic, syncModel, dataSource);
    }

    @Override
    public Map<String, String> matchFields(Object dimensionPkvalue) {
        DataSourceTypeEnum typeEnum = ((DataSource)this.getDataSource()).getType();
        return this.getSyncModel().getMatchImportDimension(typeEnum, (Long)dimensionPkvalue);
    }

    @Override
    public List<ComboItem> matchMeasureFields() {
        List<DynamicObject> measureLinkList = this.getSyncModel().getImportMeasureLinkList();
        Map<Object, List<DynamicObject>> collect = measureLinkList.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.get("measure")));
        return collect.values().stream().map(this::buildComboItems).collect(Collectors.toList());
    }

    @Override
    public Object matchMeasureField(Object measurePkvalue) {
        List<DynamicObject> measureLinkList = this.getSyncModel().getImportMeasureLinkList();
        Map<Object, List<DynamicObject>> collect = measureLinkList.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.get("measure")));
        List<DynamicObject> dynamicObjects = collect.get(measurePkvalue);
        if (dynamicObjects != null) {
            ComboItem comboItem = this.buildComboItems(dynamicObjects);
            return comboItem.getValue();
        }
        return null;
    }

    private ComboItem buildComboItems(List<DynamicObject> dynamicObjects) {
        String number = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getString("entrymembernumber")).collect(Collectors.joining(","));
        String name = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getString("entrymembername")).collect(Collectors.joining(","));
        return new ComboItem(new LocaleString(name), number);
    }
}

