/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.macc.faf.algox.XDbOutput;
import kd.macc.faf.datasource.dynamic.DataSource;
import kd.macc.faf.datasync.exec.Exec;
import kd.macc.faf.datasync.exec.data.DataSyncParams;
import kd.macc.faf.datasync.exec.data.DataSyncSchema;

public abstract class SyncSchemaExec<T extends DataSyncSchema<? extends DataSource>>
implements Exec<JobSession, DataSetX> {
    protected static final int batchSize = 1000;
    protected final T schema;
    protected final DataSyncParams params;
    protected List<List<Input>> inputs;
    protected int pos = 0;

    public SyncSchemaExec(T schema, DataSyncParams params) {
        this.schema = schema;
        this.params = params;
        this.inputs = ((DataSyncSchema)schema).getInputs(params);
    }

    public T getSchema() {
        return this.schema;
    }

    @Override
    public boolean hasNext() {
        return this.inputs != null && this.pos < this.inputs.size();
    }

    @Override
    public DataSetX exec(JobSession session) {
        if (this.inputs != null && !this.inputs.isEmpty()) {
            Input[] collect = (Input[])this.inputs.stream().skip(this.pos).limit(1000L).flatMap(Collection::stream).toArray(Input[]::new);
            this.pos += 1000;
            if (collect.length == 0) {
                return null;
            }
            return this.exec(session, collect);
        }
        return null;
    }

    protected abstract DataSetX exec(JobSession var1, Input[] var2);

    protected void outDB(DataSetX dsxOut) {
        Date date = new Date();
        DataSetX out = dsxOut.addFields(new Field[]{new Field("createtime", (DataType)DataType.TimestampType), new Field("createstamp", (DataType)DataType.LongType)}, new Object[]{date, date.getTime()});
        String sql = ((DataSyncSchema)this.getSchema()).buildOutSQL(out.getRowMeta());
        out.output((Output)new XDbOutput("fias", sql, out.getRowMeta()));
    }
}

