/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.input.bcm;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.CustomizedInput;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.datasync.exec.input.bcm.BcmApiRequest;

public class BCMCustomizedInput
implements CustomizedInput {
    private static final long serialVersionUID = 2902978845120188795L;
    private static final Log logger = LogFactory.getLog(BCMCustomizedInput.class);
    private final BcmApiRequest request;
    private final RowMeta rowMeta;

    public BCMCustomizedInput(RowMeta rowMeta, BcmApiRequest request) {
        this.rowMeta = rowMeta;
        this.request = request;
        String jsonParam = SerializationUtils.toJsonString((Object)request);
        logger.info("[faf] bcm queryData new : {}", (Object)jsonParam);
    }

    public Iterator<Object[]> createIterator() {
        try {
            String jsonParam = SerializationUtils.toJsonString((Object)this.request);
            logger.info("[faf] bcm queryData jsonParam: {}", (Object)jsonParam);
            Map res = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"bcm", (String)"OlapDataQueryMsService", (String)"queryData", (Object[])new Object[]{this.request.getModelNum(), jsonParam});
            if (Objects.equals(Boolean.TRUE, res.get("success"))) {
                Map data = (Map)FAFUtils.cast(res.get("data"));
                Collection dimensions = (Collection)FAFUtils.cast(data.get("dimension"));
                logger.info("[faf] bcm queryData success,dimensions: {}", (Object)dimensions);
                HashMap<String, Integer> indexMap = new HashMap<String, Integer>(dimensions.size());
                int pos = 0;
                for (String dimension : dimensions) {
                    indexMap.put(dimension, pos);
                    ++pos;
                }
                String[] fieldNames = this.rowMeta.getFieldNames();
                Integer[] indexs = new Integer[fieldNames.length];
                for (int i = 0; i < fieldNames.length - 1; ++i) {
                    indexs[i] = indexMap.getOrDefault(fieldNames[i], -1);
                }
                indexs[fieldNames.length - 1] = dimensions.size();
                List datas = (List)FAFUtils.cast(data.get("datas"));
                if (datas.size() < 10) {
                    logger.info("[faf] bcm queryData success,res: {}", (Object)SerializationUtils.toJsonString((Object)res));
                } else {
                    logger.info("[faf] bcm queryData success,res datas size: {}", (Object)datas.size());
                }
                return datas.stream().map(inputArr -> {
                    Object[] outArr = new Object[indexs.length];
                    for (int i = 0; i < indexs.length; ++i) {
                        if (indexs[i] < 0) continue;
                        outArr[i] = inputArr.get(indexs[i]);
                    }
                    return outArr;
                }).iterator();
            }
            logger.info("[faf] bcm queryData fail: {}", (Object)SerializationUtils.toJsonString((Object)res));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u62a5\u8868\u6570\u636e\u6e90\uff08%1$s\uff09\u4e2d\uff0c%2$s", (String)"BCMCustomizedInput_0", (String)"macc-faf-business", (Object[])new Object[0]), this.request.getDataSourceNumber(), res.get("message")));
        }
        catch (Exception ex) {
            logger.info("[faf] bcm queryData Exception:", (Object)ex);
            String message = String.format(ResManager.loadKDString((String)"\u5408\u5e76\u62a5\u8868\u6570\u636e\u6e90\uff08%1$s\uff09\u4e2d\uff0c%2$s", (String)"BCMCustomizedInput_0", (String)"macc-faf-business", (Object[])new Object[0]), this.request.getDataSourceNumber(), ex.getMessage());
            throw new KDBizException((Throwable)ex, new ErrorCode("bcm_querydata_1001", message), new Object[0]);
        }
    }

    public void close() {
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }
}

