/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.input.glbalance;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.CustomizedInput;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.macc.faf.datasync.param.BalanceQueryParam;
import kd.macc.faf.datasync.util.GlServiceHelper;
import kd.macc.faf.enums.DataSourceTypeEnum;

public class GlBalanceCustomizedInput
implements CustomizedInput {
    private static final Log logger = LogFactory.getLog(GlBalanceCustomizedInput.class);
    private static final long serialVersionUID = -8605971295975059167L;
    private final BalanceQueryParam request;
    private final RowMeta rowMeta;

    public GlBalanceCustomizedInput(RowMeta rowMeta, BalanceQueryParam request) {
        this.rowMeta = rowMeta;
        this.request = request;
        String jsonParam = SerializationUtils.toJsonString((Object)request);
        logger.info("[faf] GlBalance queryData new : {}", (Object)jsonParam);
    }

    public Iterator<Object[]> createIterator() {
        try {
            String jsonParam = SerializationUtils.toJsonString((Object)this.request);
            logger.info("[faf] GlBalance queryData jsonParam: {}", (Object)jsonParam);
            List<Map<String, Object>> res = GlServiceHelper.getBalance(this.request);
            if (CollectionUtils.isNotEmpty(res)) {
                logger.info("[faf] bcm queryData retrun: {}", (Object)res.size());
                String[] fieldNames = this.rowMeta.getFieldNames();
                int fieldLength = fieldNames.length;
                return res.stream().map(inputArr -> {
                    Object[] outArr = new Object[fieldLength];
                    for (int i = 0; i < fieldLength; ++i) {
                        outArr[i] = "period".equals(fieldNames[i]) ? Long.valueOf(this.request.getPeriodId()) : inputArr.get(fieldNames[i]);
                    }
                    return outArr;
                }).iterator();
            }
        }
        catch (Exception ex) {
            logger.info("[faf] GlBalance queryData Exception:", (Object)ex);
            String message = String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u4f59\u989d\u8868\u6570\u636e\u6e90\uff08%1$s\uff09\u4e2d\uff0c%2$s", (String)"GlBalanceCustomizedInput_0", (String)"macc-faf-business", (Object[])new Object[0]), DataSourceTypeEnum.GLBALANCE.getFormId(), ex.getMessage());
            throw new KDBizException((Throwable)ex, new ErrorCode("glBalance_querydata_1001", message), new Object[0]);
        }
        return Collections.emptyIterator();
    }

    public void close() {
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }
}

