/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec.input.glbalance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.datasync.FAFDataSyncDTO;
import kd.macc.faf.engine.task.impl.FAFDataSyncTaskBuilder;
import kd.macc.faf.engine.transformer.RelationShipWritePosTransformer;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.util.CalculateCondition;

public class GlBalanceParam {
    private static final Log logger = LogFactory.getLog(GlBalanceParam.class);
    protected FAFDataSyncDTO syncDTO;
    protected Long bookTypeId;
    protected Long acctTableId;
    protected MainEntityType outputDynEntity;
    protected IDataEntityProperty[] outputDimDynProps;
    protected List<String> sourceFieldNames;
    protected String assgrpField;
    protected Map<String, IDataEntityProperty> assgrpPropertyMap;
    protected Map<IDataEntityProperty, Object> defaultValuePropertyMap = new HashMap<IDataEntityProperty, Object>(16);
    protected RelationShipWritePosTransformer relationShipWritePosLookupService;
    protected Map<String, CalculateCondition> conditionMap = new HashMap<String, CalculateCondition>(10);
    protected Set<String> accountSelectField = new HashSet<String>(10);
    protected String accountMapField;

    public GlBalanceParam(FAFDataSyncDTO syncDTO) {
        this.syncDTO = syncDTO;
    }

    public boolean initializeParam(FAFDataSyncDTO syncDTO) {
        boolean canExecute = true;
        DynamicObject scheme = syncDTO.getScheme();
        long dataSourceId = scheme.getDynamicObject("datasource").getLong("id");
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)"pa_datasourceconfig");
        this.bookTypeId = dataSource.getLong("accountbookstype.id");
        DynamicObject model = syncDTO.getModel();
        DynamicObjectCollection dimEntry = model.getDynamicObjectCollection("dimension_entry");
        for (DynamicObject dim : dimEntry) {
            String entityNumber;
            if (DimensionNecessityEnum.ACCOUNT.getCode().equals(dim.get("necessity_dim"))) {
                entityNumber = dim.getDynamicObject("dimension").getString("dimensionsource.number");
                if ("bd_accountview".equals(entityNumber)) {
                    this.acctTableId = dim.getDynamicObject("dimension").getLong("group.id");
                    continue;
                }
                canExecute = false;
                logger.info("MACC-BALANCE: accountType noMatch" + entityNumber);
                continue;
            }
            if (!DimensionNecessityEnum.PERIOD.getCode().equals(dim.get("necessity_dim")) || "bd_period".equals(entityNumber = dim.getDynamicObject("dimension").getString("dimensionsource.number"))) continue;
            canExecute = false;
            logger.info("MACC-BALANCE: periodType noMatch" + entityNumber);
        }
        if (canExecute) {
            if (!syncDTO.getFlexFields().isEmpty()) {
                Iterator<String> iterator = syncDTO.getFlexFields().iterator();
                while (iterator.hasNext()) {
                    String flexField;
                    this.assgrpField = flexField = iterator.next();
                    this.assgrpPropertyMap = new HashMap<String, IDataEntityProperty>(32);
                }
            }
            String tableNumber = syncDTO.getTableNumber();
            this.outputDynEntity = EntityMetadataCache.getDataEntityType((String)tableNumber.substring(2));
            Map<String, String> fieldMappings = syncDTO.getFieldMappings();
            ArrayList<DynamicProperty> dimPropList = new ArrayList<DynamicProperty>(fieldMappings.size());
            this.sourceFieldNames = new ArrayList<String>(fieldMappings.size());
            for (Map.Entry<String, String> entry : fieldMappings.entrySet()) {
                if (this.assgrpField != null && entry.getValue().startsWith(this.assgrpField)) {
                    this.assgrpPropertyMap.put(entry.getValue().substring(this.assgrpField.length() + 1), (IDataEntityProperty)this.outputDynEntity.getProperty(entry.getKey()));
                    continue;
                }
                if ("account".equals(entry.getValue())) {
                    this.accountMapField = entry.getKey();
                }
                dimPropList.add(this.outputDynEntity.getProperty(entry.getKey()));
                this.sourceFieldNames.add(entry.getValue());
            }
            this.outputDimDynProps = dimPropList.toArray(new IDataEntityProperty[0]);
            Map<String, Object> defaultValueMap = syncDTO.getDefaultValueMap();
            for (Map.Entry<String, Object> entry : defaultValueMap.entrySet()) {
                this.defaultValuePropertyMap.put((IDataEntityProperty)this.outputDynEntity.getProperty(entry.getKey()), entry.getValue());
            }
            if (this.relationShipWritePosLookupService == null) {
                this.relationShipWritePosLookupService = RelationShipWritePosTransformer.buildRelationShipWritePosTransformer((String)this.outputDynEntity.getName(), (List)FAFDataSyncTaskBuilder.buildMappingRelationShip((Long)syncDTO.getScheme().getLong("id")));
            }
            Map<String, String> map = syncDTO.getConditionMap();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                CalculateCondition condition = new CalculateCondition("gl_balance", entry.getValue());
                this.conditionMap.put(entry.getKey(), condition);
                Set propertys = condition.parseProperty();
                for (String property : propertys) {
                    if (!property.contains("account.")) continue;
                    this.accountSelectField.add(property.substring("account.".length()));
                }
            }
            this.accountSelectField.add("id");
        }
        return canExecute;
    }
}

