/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.func;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class FAFAbstractReduceFunction
extends GroupReduceFunction {
    private static final Log logger = LogFactory.getLog(FAFAbstractReduceFunction.class);
    private static final long serialVersionUID = -2917431378321723185L;
    protected SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    protected RowMeta newRowMeta;
    protected long[] longs;
    protected int pos = 0;
    private static final int COUNT = 200;

    public void setRowXValue(RowX result, String key, Object value) {
        if (key == null || this.newRowMeta.getFieldIndex(key) == -1) {
            return;
        }
        int index = this.newRowMeta.getFieldIndex(key);
        Field field = this.newRowMeta.getField(key);
        DataType dataType = field.getDataType();
        if (DataType.StringType.equals((Object)dataType)) {
            if (value == null) {
                value = " ";
            }
            result.set(index, (Object)value.toString());
        } else if (DataType.LongType.equals((Object)dataType)) {
            try {
                if (value == null) {
                    return;
                }
                if (value instanceof Long) {
                    result.set(index, value);
                }
                result.set(index, (Object)Long.valueOf(value.toString()));
            }
            catch (NumberFormatException e) {
                logger.info("[MACC-FAF] NumberFormatException " + e.getMessage() + value);
            }
        } else if (DataType.BigDecimalType.equals((Object)dataType)) {
            BigDecimal bigDecimal;
            if (value == null) {
                return;
            }
            BigDecimal bigDecimal2 = bigDecimal = result.getBigDecimal(index) == null ? new BigDecimal(0) : result.getBigDecimal(index);
            if (value instanceof BigDecimal) {
                BigDecimal add = bigDecimal.add((BigDecimal)value);
                result.set(index, (Object)add);
            } else {
                try {
                    BigDecimal bigDecimalValue = new BigDecimal(value.toString());
                    BigDecimal add = bigDecimal.add(bigDecimalValue);
                    result.set(index, (Object)add);
                }
                catch (Exception e) {
                    logger.info("[MACC-FAF] parseException " + e.getMessage() + value);
                }
            }
        } else if (DataType.IntegerType.equals((Object)dataType)) {
            try {
                if (value == null) {
                    return;
                }
                if (value instanceof Integer) {
                    result.set(index, value);
                }
                result.set(index, (Object)Integer.valueOf(value.toString()));
            }
            catch (NumberFormatException e) {
                logger.info("[MACC-FAF] NumberFormatException " + e.getMessage() + value);
            }
        } else if (DataType.TimestampType.equals((Object)dataType)) {
            if (value == null) {
                return;
            }
            if (value instanceof Date) {
                result.set(index, value);
            } else {
                try {
                    Date date = this.format.parse(value.toString());
                    result.set(index, (Object)date);
                }
                catch (ParseException e) {
                    logger.info("[MACC-FAF] parseException " + e.getMessage() + value);
                }
            }
        } else {
            result.set(index, value);
        }
    }

    protected Object getId() {
        if (this.longs == null || this.pos >= 200) {
            this.longs = DB.genGlobalLongIds((int)200);
            this.pos = 0;
        }
        return this.longs[this.pos++];
    }
}

