/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.func;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.macc.faf.datasync.FAFDataSyncPOJO;
import kd.macc.faf.datasync.func.FAFAbstractReduceFunction;
import kd.macc.faf.datasync.transformer.AlgoXRelationShipWritePosTransformer;
import kd.macc.faf.util.CalculateCondition;
import kd.macc.faf.util.ConditionExecutor;

public class FAFBizVoucherReduceGroupFunction
extends FAFAbstractReduceFunction {
    private static final long serialVersionUID = 1209166427405685540L;
    private RowMeta rowMeta;
    private FAFDataSyncPOJO paDataSyncPOJO;
    private Object[] rowXValue;
    private Map<String, List<String>> subEntryFieldMap;
    private Map<String, String> directInputMap;
    private List<String> assistList;

    public FAFBizVoucherReduceGroupFunction(RowMeta rowMeta, RowMeta newRowMeta, FAFDataSyncPOJO paDataSyncPOJO) {
        this.rowMeta = rowMeta;
        this.newRowMeta = newRowMeta;
        this.paDataSyncPOJO = paDataSyncPOJO;
        this.rowXValue = new Object[newRowMeta.getFieldCount()];
        for (int i = 0; i < newRowMeta.getFields().length; ++i) {
            if (DataType.StringType.equals((Object)newRowMeta.getField(i).getDataType())) {
                this.rowXValue[i] = " ";
                continue;
            }
            if (!DataType.LongType.equals((Object)newRowMeta.getField(i).getDataType())) continue;
            this.rowXValue[i] = 0L;
        }
        paDataSyncPOJO.buildTransformer(newRowMeta);
        int size = paDataSyncPOJO.getFieldMappings().size();
        this.subEntryFieldMap = new HashMap<String, List<String>>(size);
        this.directInputMap = new HashMap<String, String>(size);
        this.assistList = new ArrayList<String>(size);
        for (Map.Entry<String, String> entry : paDataSyncPOJO.getFieldMappings().entrySet()) {
            String sourceField = entry.getValue();
            if (sourceField == null) continue;
            int fieldIndex = rowMeta.getFieldIndex(sourceField, false);
            if (fieldIndex != -1) {
                this.directInputMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (sourceField.startsWith(paDataSyncPOJO.getEntryNumber())) {
                String[] assistSplit = sourceField.substring(paDataSyncPOJO.getEntryNumber().length() + 1).split("_");
                if (assistSplit.length != 2 || rowMeta.getFieldIndex(entry.getKey(), false) == -1) continue;
                this.assistList.add(entry.getKey());
                continue;
            }
            if (!sourceField.startsWith("dim_")) continue;
            String key = sourceField.substring("dim_".length());
            List<String> targetFields = this.subEntryFieldMap.get(key);
            if (targetFields == null) {
                this.subEntryFieldMap.putIfAbsent(key, new ArrayList<String>(Collections.singletonList(entry.getKey())));
                continue;
            }
            targetFields.add(entry.getKey());
        }
    }

    public RowMeta getResultRowMeta() {
        return this.newRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector out) {
        AlgoXRelationShipWritePosTransformer transformer = this.paDataSyncPOJO.getTransformer();
        RowX result = new RowX(this.newRowMeta.getFieldCount());
        result.setValues((Object[])this.rowXValue.clone());
        Long cacheId = null;
        for (RowX rowX : iterable) {
            String flexField;
            Long id = rowX.getLong(this.rowMeta.getFieldIndex("id"));
            if (id == null) continue;
            if (!id.equals(cacheId)) {
                if (cacheId != null) {
                    if (transformer != null) {
                        transformer.convert(result, this.newRowMeta);
                    }
                    out.collect(result);
                    result = new RowX(this.newRowMeta.getFieldCount());
                    result.setValues((Object[])this.rowXValue.clone());
                }
                cacheId = id;
                this.setRowXValue(result, "id", this.getId());
                this.setRowXValue(result, "sourcebillid", id);
                for (Map.Entry<String, String> entry : this.directInputMap.entrySet()) {
                    this.setRowXValue(result, entry.getKey(), rowX.get(this.rowMeta.getFieldIndex(entry.getValue())));
                }
                for (String string : this.assistList) {
                    this.setRowXValue(result, string, rowX.get(this.rowMeta.getFieldIndex(string)));
                }
                for (Map.Entry entry : this.paDataSyncPOJO.getDefaultValueMap().entrySet()) {
                    this.setRowXValue(result, (String)entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : this.paDataSyncPOJO.getConditionMap().entrySet()) {
                    CalculateCondition condition = new CalculateCondition(this.paDataSyncPOJO.getDataSourceNumber(), (String)entry.getValue());
                    this.setRowXValue(result, (String)entry.getKey(), ConditionExecutor.exeMeasureCondition((RowX)rowX, (CalculateCondition)condition, (RowMeta)this.rowMeta));
                }
            }
            if (this.subEntryFieldMap.isEmpty() || this.subEntryFieldMap.get(flexField = rowX.getString(this.rowMeta.getFieldIndex("entryentity.subentryentity.flexfield"))) == null) continue;
            for (String field : this.subEntryFieldMap.get(flexField)) {
                this.setRowXValue(result, field, rowX.getString(this.rowMeta.getFieldIndex("entryentity.subentryentity.value")));
            }
        }
        if (cacheId != null) {
            if (transformer != null) {
                transformer.convert(result, this.newRowMeta);
            }
            out.collect(result);
        }
    }
}

