/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.macc.faf.datasync.FAFDataSyncPOJO;
import kd.macc.faf.datasync.func.FAFAbstractReduceFunction;
import kd.macc.faf.datasync.transformer.AlgoXRelationShipWritePosTransformer;
import kd.macc.faf.util.CalculateCondition;
import kd.macc.faf.util.ConditionExecutor;

public class FAFBizVoucherReduceMulitGroupFunction
extends FAFAbstractReduceFunction {
    private static final long serialVersionUID = -5043350690486792967L;
    private RowMeta rowMeta;
    private FAFDataSyncPOJO paDataSyncPOJO;
    private Object[] rowXValue;
    private Map<String, List<String>> subEntryFieldMap;
    private Map<String, String> directInputMap;
    private List<String> assistList;
    private final int entryNumberIndex;
    private final Map<Integer, Set<String>> levelMeasureMap;

    public FAFBizVoucherReduceMulitGroupFunction(RowMeta rowMeta, RowMeta newRowMeta, FAFDataSyncPOJO paDataSyncPOJO) {
        this.rowMeta = rowMeta;
        this.newRowMeta = newRowMeta;
        this.paDataSyncPOJO = paDataSyncPOJO;
        this.rowXValue = new Object[newRowMeta.getFieldCount()];
        for (int i = 0; i < newRowMeta.getFields().length; ++i) {
            if (DataType.StringType.equals((Object)newRowMeta.getField(i).getDataType())) {
                this.rowXValue[i] = " ";
                continue;
            }
            if (DataType.LongType.equals((Object)newRowMeta.getField(i).getDataType())) {
                this.rowXValue[i] = 0L;
                continue;
            }
            if (!DataType.BigDecimalType.equals((Object)newRowMeta.getField(i).getDataType())) continue;
            this.rowXValue[i] = BigDecimal.ZERO;
        }
        paDataSyncPOJO.buildTransformer(newRowMeta);
        int size = paDataSyncPOJO.getFieldMappings().size();
        this.subEntryFieldMap = new HashMap<String, List<String>>(size);
        this.directInputMap = new HashMap<String, String>(size);
        this.assistList = new ArrayList<String>(size);
        for (Map.Entry<String, String> entry : paDataSyncPOJO.getFieldMappings().entrySet()) {
            String sourceField = entry.getValue();
            if (sourceField == null) continue;
            int fieldIndex = rowMeta.getFieldIndex(sourceField, false);
            if (fieldIndex != -1) {
                this.directInputMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (sourceField.startsWith(paDataSyncPOJO.getEntryNumber())) {
                String[] assistSplit = sourceField.substring(paDataSyncPOJO.getEntryNumber().length() + 1).split("_");
                if (assistSplit.length != 2 || rowMeta.getFieldIndex(entry.getKey(), false) == -1) continue;
                this.assistList.add(entry.getKey());
                continue;
            }
            if (!sourceField.startsWith("dim_")) continue;
            String key = sourceField.substring("dim_".length());
            List<String> targetFields = this.subEntryFieldMap.get(key);
            if (targetFields == null) {
                this.subEntryFieldMap.putIfAbsent(key, new ArrayList<String>(Collections.singletonList(entry.getKey())));
                continue;
            }
            targetFields.add(entry.getKey());
        }
        this.entryNumberIndex = rowMeta.getFieldIndex(paDataSyncPOJO.getEntryNumber(), false);
        this.levelMeasureMap = paDataSyncPOJO.getLevelMeasureMap();
    }

    public RowMeta getResultRowMeta() {
        return this.newRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector out) {
        AlgoXRelationShipWritePosTransformer transformer = this.paDataSyncPOJO.getTransformer();
        HashMap<String, CalculateCondition> commonCalContionMap = new HashMap<String, CalculateCondition>(10);
        HashMap<String, CalculateCondition> aiAsstCalContionMap = new HashMap<String, CalculateCondition>(10);
        if (this.paDataSyncPOJO.getConditionMap() != null && !this.paDataSyncPOJO.getConditionMap().isEmpty()) {
            for (Map.Entry<String, String> conditionEntry : this.paDataSyncPOJO.getConditionMap().entrySet()) {
                CalculateCondition condition = new CalculateCondition(this.paDataSyncPOJO.getDataSourceNumber(), conditionEntry.getValue());
                Set fieldSet = condition.parseProperty();
                if (fieldSet.contains("entryentity.subentryentity.flexfield") || fieldSet.contains("entryentity.subentryentity.value")) {
                    aiAsstCalContionMap.put(conditionEntry.getKey(), condition);
                    continue;
                }
                commonCalContionMap.put(conditionEntry.getKey(), condition);
            }
        }
        HashMap<Long, RowX> reduceMap = new HashMap<Long, RowX>(20);
        Long cacheEntryId = null;
        int i = 0;
        for (RowX rowX : iterable) {
            String flexField;
            RowX result;
            boolean newResult = false;
            Long entryId = 0L;
            if (this.entryNumberIndex != -1) {
                entryId = rowX.getLong(this.entryNumberIndex);
            }
            if ((result = (RowX)reduceMap.get(entryId)) == null) {
                newResult = true;
                result = new RowX(this.newRowMeta.getFieldCount());
                result.setValues((Object[])this.rowXValue.clone());
                reduceMap.put(entryId, result);
            }
            if (newResult && (cacheEntryId == null || !cacheEntryId.equals(entryId))) {
                this.setRowXValue(result, "id", this.getId());
                this.setRowXValue(result, "sourcebillid", rowX.getLong(this.rowMeta.getFieldIndex("id")));
                for (Map.Entry<Object, Object> entry : this.directInputMap.entrySet()) {
                    if (i > 0 && this.levelMeasureMap.get(1) != null && this.levelMeasureMap.get(1).contains(entry.getValue())) continue;
                    this.setRowXValue(result, (String)entry.getKey(), rowX.get(this.rowMeta.getFieldIndex((String)entry.getValue())));
                }
                for (String string : this.assistList) {
                    this.setRowXValue(result, string, rowX.get(this.rowMeta.getFieldIndex(string)));
                }
                for (Map.Entry entry : this.paDataSyncPOJO.getDefaultValueMap().entrySet()) {
                    this.setRowXValue(result, (String)entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : commonCalContionMap.entrySet()) {
                    this.setRowXValue(result, (String)entry.getKey(), ConditionExecutor.exeMeasureCondition((RowX)rowX, (CalculateCondition)((CalculateCondition)entry.getValue()), (RowMeta)this.rowMeta));
                }
            }
            for (Map.Entry entry : aiAsstCalContionMap.entrySet()) {
                Object conditionValue = ConditionExecutor.exeMeasureCondition((RowX)rowX, (CalculateCondition)((CalculateCondition)entry.getValue()), (RowMeta)this.rowMeta);
                if (conditionValue == null) continue;
                this.setRowXValue(result, (String)entry.getKey(), conditionValue);
            }
            if (!this.subEntryFieldMap.isEmpty() && this.subEntryFieldMap.get(flexField = rowX.getString(this.rowMeta.getFieldIndex("entryentity.subentryentity.flexfield"))) != null) {
                for (String field : this.subEntryFieldMap.get(flexField)) {
                    this.setRowXValue(result, field, rowX.getString(this.rowMeta.getFieldIndex("entryentity.subentryentity.value")));
                }
            }
            cacheEntryId = entryId;
            ++i;
        }
        for (RowX value : reduceMap.values()) {
            if (transformer != null) {
                transformer.convert(value, this.newRowMeta);
            }
            out.collect(value);
        }
    }
}

