/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.func;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.formula.FormulaEngine;
import kd.bos.util.StringUtils;
import kd.macc.faf.datasync.DimConditionDTO;
import kd.macc.faf.datasync.util.FAFDataSyncUtil;

public class FAFConditionDataFunction
extends MapFunction {
    private static final long serialVersionUID = -80770703763743661L;
    List<DimConditionDTO> dimConditionDTOS;
    private final RowMeta rowMeta;

    public FAFConditionDataFunction(RowMeta rowMeta, List<DimConditionDTO> dimConditionDTOS) {
        this.rowMeta = rowMeta;
        this.dimConditionDTOS = dimConditionDTOS;
    }

    public RowX map(RowX rowX) {
        RowX result = rowX.copy();
        for (DimConditionDTO dimConditionDTO : this.dimConditionDTOS) {
            String condition = dimConditionDTO.getCondition();
            if (StringUtils.isEmpty((String)condition)) continue;
            Map<String, String> fieldMap = dimConditionDTO.getFieldMap();
            HashMap<String, Object> ctx = new HashMap<String, Object>(fieldMap.size());
            for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
                Field useField = this.rowMeta.getField(entry.getValue(), false);
                if (useField == null) continue;
                Object value = rowX.get(this.rowMeta.getFieldIndex(entry.getValue()));
                if (DataType.BigDecimalType.equals((Object)useField.getDataType()) && value == null) {
                    ctx.put(entry.getKey(), BigDecimal.ZERO);
                    continue;
                }
                if (DataType.StringType.equals((Object)useField.getDataType()) && value != null && StringUtils.isEmpty((String)value.toString())) {
                    ctx.put(entry.getKey(), null);
                    continue;
                }
                ctx.put(entry.getKey(), value);
            }
            Object conditionResult = FormulaEngine.execExcelFormula((String)condition, ctx);
            if (!(conditionResult instanceof Boolean) || !Boolean.FALSE.equals(conditionResult)) continue;
            FAFDataSyncUtil.setRowXValue(result, dimConditionDTO.getSourceModelField(), null, this.rowMeta);
        }
        return result;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

