/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.func;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.macc.faf.datasync.FAFDataSyncPOJO;
import kd.macc.faf.datasync.util.FAFDataSyncUtil;
import kd.macc.faf.helper.EntityMetaHelper;

public class FAFGlassistMapFunction
extends MapFunction {
    private final RowMeta rowMeta;
    private final RowMeta newRowMeta;
    private final Map<String, String> flexFieldMappings = new HashMap<String, String>(10);
    private final String flexField;
    private final List<String> assistPrefixs;
    private final Object[] rowXValue;
    private String propType;
    private String propValue;

    public FAFGlassistMapFunction(RowMeta rowMeta, RowMeta resultRowMeta, FAFDataSyncPOJO paDataSyncPOJO, String flexField, String flexForm) {
        this.rowMeta = rowMeta;
        this.flexField = flexField;
        this.assistPrefixs = EntityMetaHelper.matchFlexProperty((String)paDataSyncPOJO.getDataSourceNumber());
        Map<String, String> fieldMappings = paDataSyncPOJO.getFieldMappings();
        for (Map.Entry<String, String> entry : fieldMappings.entrySet()) {
            for (String assistPrefix : this.assistPrefixs) {
                if (!entry.getValue().startsWith(assistPrefix)) continue;
                this.flexFieldMappings.put(entry.getKey(), entry.getValue());
            }
        }
        Field[] leftFields = rowMeta.getFields();
        ArrayList<Field> fieldList = new ArrayList<Field>(Arrays.asList(leftFields));
        for (String targetField : this.flexFieldMappings.keySet()) {
            fieldList.add(resultRowMeta.getField(targetField).copy());
        }
        this.newRowMeta = new RowMeta(fieldList.toArray(new Field[0]));
        this.rowXValue = new Object[this.newRowMeta.getFieldCount()];
        for (int i = 0; i < this.newRowMeta.getFields().length; ++i) {
            if (!DataType.StringType.equals((Object)this.newRowMeta.getField(i).getDataType())) continue;
            this.rowXValue[i] = "";
        }
        if (flexForm.startsWith("gl_assist")) {
            this.propType = "_asstype" + flexForm;
            this.propValue = "_assval" + flexForm;
        } else if (flexForm.startsWith("bd_flexauxprop")) {
            this.propType = "_auxproptype" + flexForm;
            this.propValue = "_auxpropval" + flexForm;
        }
    }

    public RowX map(RowX rowX) {
        RowX result = new RowX(this.newRowMeta.getFieldCount());
        result.setValues((Object[])this.rowXValue.clone());
        for (int j = 0; j < this.rowMeta.getFieldCount(); ++j) {
            result.set(j, rowX.get(j));
        }
        Long flexFieldValue = rowX.getLong(this.rowMeta.getFieldIndex(this.flexField + this.propValue));
        String asstype = rowX.getString(this.rowMeta.getFieldIndex(this.flexField + this.propType));
        if (asstype != null && flexFieldValue != null) {
            for (Map.Entry<String, String> entry : this.flexFieldMappings.entrySet()) {
                for (String assistPrefix : this.assistPrefixs) {
                    if (!entry.getValue().startsWith(assistPrefix) || !entry.getValue().substring(assistPrefix.length() + 1).equals(asstype)) continue;
                    result.set(this.newRowMeta.getFieldIndex(entry.getKey()), (Object)flexFieldValue);
                    FAFDataSyncUtil.setRowXValue(result, entry.getKey(), flexFieldValue, this.newRowMeta);
                }
            }
        }
        return result;
    }

    public RowMeta getResultRowMeta() {
        return this.newRowMeta;
    }
}

