/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.func;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.macc.faf.datasync.FAFDataSyncPOJO;
import kd.macc.faf.datasync.func.FAFAbstractReduceFunction;
import kd.macc.faf.helper.EntityMetaHelper;

public class FAFGlassistReduceGroupFunction
extends FAFAbstractReduceFunction {
    private static final long serialVersionUID = 7786553560664183903L;
    private final RowMeta rowMeta;
    private final FAFDataSyncPOJO paDataSyncPOJO;
    private final Map<String, String> flexFieldMappings = new HashMap<String, String>(10);
    private final String flexField;
    private final List<String> assistPrefixs;
    private final Object[] rowXValue;
    private final String entityNumber;

    public FAFGlassistReduceGroupFunction(RowMeta rowMeta, RowMeta resultRowMeta, FAFDataSyncPOJO paDataSyncPOJO, String flexField, String entityNumber) {
        this.rowMeta = rowMeta;
        this.paDataSyncPOJO = paDataSyncPOJO;
        this.flexField = flexField;
        this.entityNumber = entityNumber;
        this.assistPrefixs = EntityMetaHelper.matchFlexProperty((String)paDataSyncPOJO.getDataSourceNumber());
        Map<String, String> fieldMappings = paDataSyncPOJO.getFieldMappings();
        for (Map.Entry<String, String> entry : fieldMappings.entrySet()) {
            for (String assistPrefix : this.assistPrefixs) {
                if (!entry.getValue().startsWith(assistPrefix)) continue;
                this.flexFieldMappings.put(entry.getKey(), entry.getValue());
            }
        }
        Field[] leftFields = rowMeta.getFields();
        ArrayList<Field> fieldList = new ArrayList<Field>(Arrays.asList(leftFields));
        for (String targetField : this.flexFieldMappings.keySet()) {
            if (rowMeta.getFieldIndex(targetField, false) != -1) continue;
            fieldList.add(resultRowMeta.getField(targetField).copy());
        }
        this.newRowMeta = new RowMeta(fieldList.toArray(new Field[0]));
        this.rowXValue = new Object[this.newRowMeta.getFieldCount()];
        for (int i = 0; i < this.newRowMeta.getFields().length; ++i) {
            if (!DataType.StringType.equals((Object)this.newRowMeta.getField(i).getDataType())) continue;
            this.rowXValue[i] = "";
        }
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowX result = new RowX(this.newRowMeta.getFieldCount());
        result.setValues((Object[])this.rowXValue.clone());
        int i = 0;
        for (RowX rowX : iterable) {
            Long entryId;
            if (i++ == 0) {
                for (int j = 0; j < this.rowMeta.getFieldCount(); ++j) {
                    result.set(j, rowX.get(j));
                }
            }
            if ((entryId = rowX.getLong(this.rowMeta.getFieldIndex(this.paDataSyncPOJO.getEntryNumber() == null ? "id" : this.paDataSyncPOJO.getEntryNumber()))) == null || entryId == 0L) {
                collector.collect(result);
                result = new RowX(this.newRowMeta.getFieldCount());
                result.setValues((Object[])this.rowXValue.clone());
                i = 0;
                continue;
            }
            Object flexFieldValue = rowX.get(this.rowMeta.getFieldIndex(this.flexField + "_assval" + this.entityNumber));
            String asstype = rowX.getString(this.rowMeta.getFieldIndex(this.flexField + "_asstype" + this.entityNumber));
            if (asstype == null || flexFieldValue == null) continue;
            for (Map.Entry<String, String> entry : this.flexFieldMappings.entrySet()) {
                for (String assistPrefix : this.assistPrefixs) {
                    if (!entry.getValue().startsWith(assistPrefix) || !entry.getValue().substring(assistPrefix.length() + 1).equals(asstype)) continue;
                    result.set(this.newRowMeta.getFieldIndex(entry.getKey()), flexFieldValue);
                    this.setRowXValue(result, entry.getKey(), flexFieldValue);
                }
            }
        }
        if (i != 0) {
            collector.collect(result);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.newRowMeta;
    }
}

