/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.func;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.macc.faf.datasync.model.MultiClassDimensionInfo;
import kd.macc.faf.datasync.util.FAFDataSyncUtil;

public class FAFMultiClassDataFunction
extends MapFunction {
    private static final long serialVersionUID = 4604398141378988670L;
    private final RowMeta rowMeta;
    private List<MultiClassDimensionInfo> multiClassDimensionInfoList;

    public FAFMultiClassDataFunction(RowMeta rowMeta, List<MultiClassDimensionInfo> multiClassDimensionInfoList) {
        this.rowMeta = rowMeta;
        this.multiClassDimensionInfoList = multiClassDimensionInfoList.stream().filter(MultiClassDimensionInfo::isIfOriginalField).collect(Collectors.toList());
        for (MultiClassDimensionInfo info : this.multiClassDimensionInfoList) {
            info.setAliasIndex(rowMeta.getFieldIndex(info.getItemClassTypeAlias(), true));
        }
    }

    public RowX map(RowX row) {
        if (this.multiClassDimensionInfoList != null) {
            for (MultiClassDimensionInfo info : this.multiClassDimensionInfoList) {
                if (info.getTargetFieldEntity().equals(row.getString(info.getAliasIndex().intValue()))) continue;
                FAFDataSyncUtil.setRowXValue(row, info.getTargetField(), null, this.rowMeta);
            }
        }
        return row;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

