/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.func;

import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.macc.faf.datasync.func.FAFAbstractReduceFunction;
import kd.macc.faf.datasync.transformer.AlgoXColumnValueWritePosTransformer;
import kd.macc.faf.datasync.transformer.AlgoXRelationShipWritePosTransformer;
import kd.macc.faf.dto.OlapDataExtractingDTO;
import kd.macc.faf.enums.FAFOlapSelectTypeEnum;

public class FAFOlapDataProcessFunction
extends FAFAbstractReduceFunction {
    private static final long serialVersionUID = -39705236138849650L;
    private final Object[] rowXValue;
    private final OlapDataExtractingDTO extractingDto;
    protected RowMeta rowMeta;
    protected Map<String, Map<String, Long>> entityNumberTransIdMap;
    private final AlgoXRelationShipWritePosTransformer relationShipTransformer;
    private final AlgoXColumnValueWritePosTransformer columnValueTransformer;

    public FAFOlapDataProcessFunction(RowMeta newRowMeta, RowMeta rowMeta, OlapDataExtractingDTO extractingDto, Map<String, Map<String, Long>> entityNumberTransIdMap) {
        this.newRowMeta = newRowMeta;
        this.rowMeta = rowMeta;
        this.extractingDto = extractingDto;
        this.entityNumberTransIdMap = entityNumberTransIdMap;
        this.rowXValue = new Object[newRowMeta.getFieldCount()];
        for (int i = 0; i < newRowMeta.getFields().length; ++i) {
            if (DataType.StringType.equals((Object)newRowMeta.getField(i).getDataType())) {
                this.rowXValue[i] = " ";
                continue;
            }
            if (!DataType.LongType.equals((Object)newRowMeta.getField(i).getDataType())) continue;
            this.rowXValue[i] = 0L;
        }
        this.relationShipTransformer = AlgoXRelationShipWritePosTransformer.buildTransformer(extractingDto.getMappingRelationShipDTOs(), newRowMeta);
        this.columnValueTransformer = AlgoXColumnValueWritePosTransformer.buildMulToSingleFieldTransformer(newRowMeta, rowMeta, extractingDto.getTransformFieldIndexMap(), (List)extractingDto.getSelectDimensionMap().get(FAFOlapSelectTypeEnum.TRANS_TYPE.getIntCode()));
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowX result = new RowX(this.newRowMeta.getFieldCount());
        result.setValues((Object[])this.rowXValue.clone());
        this.setRowXValue(result, "id", this.getId());
        for (RowX rowX : iterable) {
            for (Map.Entry entry : this.extractingDto.getFieldMappings().entrySet()) {
                int fieldIndex;
                String sourceField = (String)entry.getKey();
                if (sourceField == null || (fieldIndex = this.rowMeta.getFieldIndex(sourceField, false)) == -1 || this.entityNumberTransIdMap.get(sourceField) == null) continue;
                this.setRowXValue(result, (String)entry.getValue(), this.entityNumberTransIdMap.get(sourceField).get(rowX.getString(fieldIndex)));
            }
            this.columnValueTransformer.convert(rowX, result);
        }
        for (Map.Entry entry : this.extractingDto.getDefaultValueMap().entrySet()) {
            this.setRowXValue(result, (String)entry.getKey(), entry.getValue());
        }
        this.relationShipTransformer.convert(result, this.newRowMeta);
        collector.collect(result);
    }

    public RowMeta getResultRowMeta() {
        return this.newRowMeta;
    }
}

