/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.func;

import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.macc.faf.datasync.model.MultiClassDimensionInfo;
import kd.macc.faf.datasync.util.FAFDataSyncUtil;

public class FAFReplaceDataFunction
extends MapFunction {
    private static final long serialVersionUID = 8327709209776402281L;
    private final Integer sourceFieldIndex;
    private String targetField;
    private final RowMeta rowMeta;
    private MultiClassDimensionInfo multiClassInfo;

    public FAFReplaceDataFunction(String sourceField, String targetField, RowMeta rowMeta, MultiClassDimensionInfo multiClassInfo) {
        this.sourceFieldIndex = rowMeta.getFieldIndex(sourceField, false);
        if (targetField.length() > 3) {
            this.targetField = targetField.substring(0, targetField.length() - 3);
        }
        this.rowMeta = rowMeta;
        if (multiClassInfo != null) {
            this.multiClassInfo = multiClassInfo;
            this.multiClassInfo.setAliasIndex(rowMeta.getFieldIndex(multiClassInfo.getItemClassTypeAlias()));
        }
    }

    public RowX map(RowX rowX) {
        if (this.sourceFieldIndex != -1 && this.targetField != null) {
            FAFDataSyncUtil.setRowXValue(rowX, this.targetField, rowX.get(this.sourceFieldIndex.intValue()), this.rowMeta);
        }
        if (this.multiClassInfo != null && !this.multiClassInfo.getTargetFieldEntity().equals(rowX.getString(this.multiClassInfo.getAliasIndex().intValue()))) {
            FAFDataSyncUtil.setRowXValue(rowX, this.targetField, null, this.rowMeta);
        }
        return rowX;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

