/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.db.DB;
import kd.bos.util.CollectionUtils;
import kd.macc.faf.datasync.FAFDataSyncPOJO;
import kd.macc.faf.datasync.transformer.AlgoXRelationShipWritePosTransformer;
import kd.macc.faf.datasync.transformer.DateConversionTransFormer;
import kd.macc.faf.datasync.util.FAFDataSyncUtil;
import kd.macc.faf.helper.EntityMetaHelper;
import kd.macc.faf.util.CalculateCondition;
import kd.macc.faf.util.ConditionExecutor;

public class FAFSimpleDataSyncFunction
extends MapFunction {
    private static final long serialVersionUID = -4543539048464166208L;
    private RowMeta rowMeta;
    private RowMeta newRowMeta;
    private FAFDataSyncPOJO paDataSyncPOJO;
    private Object[] rowXValue;
    private Map<String, String> directInputMap;
    private List<String> assistList;

    public FAFSimpleDataSyncFunction(RowMeta rowMeta, RowMeta newRowMeta, FAFDataSyncPOJO paDataSyncPOJO, Set<String> flexFields) {
        this.rowMeta = rowMeta;
        this.newRowMeta = newRowMeta;
        this.paDataSyncPOJO = paDataSyncPOJO;
        this.rowXValue = new Object[newRowMeta.getFieldCount()];
        for (int i = 0; i < newRowMeta.getFields().length; ++i) {
            if (DataType.StringType.equals((Object)newRowMeta.getField(i).getDataType())) {
                this.rowXValue[i] = " ";
                continue;
            }
            if (DataType.LongType.equals((Object)newRowMeta.getField(i).getDataType())) {
                this.rowXValue[i] = 0L;
                continue;
            }
            if (!DataType.BigDecimalType.equals((Object)newRowMeta.getField(i).getDataType())) continue;
            this.rowXValue[i] = BigDecimal.ZERO;
        }
        int size = paDataSyncPOJO.getFieldMappings().size();
        this.assistList = new ArrayList<String>(10);
        this.directInputMap = new HashMap<String, String>(size);
        for (Map.Entry<String, String> entry : paDataSyncPOJO.getFieldMappings().entrySet()) {
            String sourceField = entry.getValue();
            if (sourceField == null) continue;
            int fieldIndex = rowMeta.getFieldIndex(sourceField, false);
            if (fieldIndex != -1 && !entry.getKey().equals(paDataSyncPOJO.getDateConversionFiled())) {
                this.directInputMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!CollectionUtils.isNotEmpty(flexFields)) continue;
            List assistPrefixs = EntityMetaHelper.matchFlexProperty((String)paDataSyncPOJO.getDataSourceNumber());
            for (String assistPrefix : assistPrefixs) {
                if (!sourceField.startsWith(assistPrefix) || rowMeta.getFieldIndex(entry.getKey(), false) == -1) continue;
                this.assistList.add(entry.getKey());
            }
        }
        paDataSyncPOJO.buildTransformer(newRowMeta);
    }

    public RowX map(RowX rowX) {
        RowX result = new RowX(this.newRowMeta.getFieldCount());
        result.setValues((Object[])this.rowXValue.clone());
        FAFDataSyncUtil.setRowXValue(result, "id", DB.genGlobalLongId(), this.newRowMeta);
        FAFDataSyncUtil.setRowXValue(result, "sourcebillid", rowX.get(this.rowMeta.getFieldIndex("id")), this.newRowMeta);
        for (Map.Entry<String, String> entry : this.directInputMap.entrySet()) {
            FAFDataSyncUtil.setRowXValue(result, entry.getKey(), rowX.get(this.rowMeta.getFieldIndex(entry.getValue())), this.newRowMeta);
        }
        for (String string : this.assistList) {
            FAFDataSyncUtil.setRowXValue(result, string, rowX.get(this.rowMeta.getFieldIndex(string)), this.newRowMeta);
        }
        for (Map.Entry entry : this.paDataSyncPOJO.getDefaultValueMap().entrySet()) {
            FAFDataSyncUtil.setRowXValue(result, (String)entry.getKey(), entry.getValue(), this.newRowMeta);
        }
        for (Map.Entry entry : this.paDataSyncPOJO.getConditionMap().entrySet()) {
            CalculateCondition condition = new CalculateCondition(this.paDataSyncPOJO.getDataSourceNumber(), (String)entry.getValue());
            FAFDataSyncUtil.setRowXValue(result, (String)entry.getKey(), ConditionExecutor.exeMeasureCondition((RowX)rowX, (CalculateCondition)condition, (RowMeta)this.rowMeta), this.newRowMeta);
        }
        AlgoXRelationShipWritePosTransformer transformer = this.paDataSyncPOJO.getTransformer();
        DateConversionTransFormer dateConversionTransFormer = this.paDataSyncPOJO.getDateTransFormer();
        if (transformer != null) {
            transformer.convert(result, this.newRowMeta);
        }
        if (dateConversionTransFormer != null) {
            dateConversionTransFormer.convert(result, this.newRowMeta, rowX, this.rowMeta);
        }
        return result;
    }

    public RowMeta getResultRowMeta() {
        return this.newRowMeta;
    }
}

