/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.func;

import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;
import kd.macc.faf.util.AnalysisModelHashUtil;

public class FillDimHashFlatMapFunction
extends FlatMapFunction {
    public static final long FLAG_DIM_HASH_CHANGED = 99L;
    private final RowMeta rowMeta;
    private final List<String> modelHashDimensionNumberList;
    private final int dimHashIndex;
    private final int collectStatusIndex;

    public FillDimHashFlatMapFunction(RowMeta rowMeta, List<String> modelHashDimensionNumberList) {
        this.rowMeta = rowMeta;
        this.modelHashDimensionNumberList = modelHashDimensionNumberList;
        this.dimHashIndex = rowMeta.getFieldIndex("dimhash", false);
        this.collectStatusIndex = rowMeta.getFieldIndex("collectstatus");
    }

    public void flatMap(RowX rowX, Collector collector) {
        String dimHash;
        if (this.dimHashIndex >= 0 && StringUtils.isBlank((String)(dimHash = rowX.getString(this.dimHashIndex)))) {
            RowX copyRowX = rowX.copy();
            dimHash = AnalysisModelHashUtil.calculateDimHash((RowMeta)this.rowMeta, (RowX)rowX, this.modelHashDimensionNumberList);
            copyRowX.set(this.dimHashIndex, (Object)dimHash);
            copyRowX.set(this.collectStatusIndex, (Object)99L);
            collector.collect(copyRowX);
            rowX.set(this.dimHashIndex, (Object)dimHash);
        }
        collector.collect(rowX);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

